/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class LogstashEncoder
extends EncoderBase<ILoggingEvent> {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
    private boolean immediateFlush = true;

    public void doEncode(ILoggingEvent event) throws IOException {
        ObjectNode eventNode = MAPPER.createObjectNode();
        eventNode.put("@timestamp", DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(event.getTimeStamp()));
        eventNode.put("@message", event.getFormattedMessage());
        eventNode.put("@fields", (JsonNode)this.createFields(event));
        IOUtils.write((byte[])MAPPER.writeValueAsBytes((Object)eventNode), (OutputStream)this.outputStream);
        IOUtils.write((String)CoreConstants.LINE_SEPARATOR, (OutputStream)this.outputStream);
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    private ObjectNode createFields(ILoggingEvent event) {
        ObjectNode fieldsNode = MAPPER.createObjectNode();
        fieldsNode.put("logger_name", event.getLoggerName());
        fieldsNode.put("thread_name", event.getThreadName());
        fieldsNode.put("level", event.getLevel().toString());
        fieldsNode.put("level_value", event.getLevel().toInt());
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null) {
            fieldsNode.put("stack_trace", ThrowableProxyUtil.asString((IThrowableProxy)throwableProxy));
        }
        Map mdc = event.getMDCPropertyMap();
        for (Map.Entry entry : mdc.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            fieldsNode.put(key, value);
        }
        return fieldsNode;
    }

    public void close() throws IOException {
        IOUtils.write((String)IOUtils.LINE_SEPARATOR, (OutputStream)this.outputStream);
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }
}

