/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.spi.LifeCycle;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.Map;
import net.logstash.logback.decorate.JsonFactoryDecorator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import net.logstash.logback.decorate.NullJsonFactoryDecorator;
import net.logstash.logback.decorate.NullJsonGeneratorDecorator;
import net.logstash.logback.encoder.org.apache.commons.lang.time.FastDateFormat;
import net.logstash.logback.fieldnames.LogstashCommonFieldNames;

abstract class LogstashAbstractFormatter<EventType extends DeferredProcessingAware, FieldNamesType extends LogstashCommonFieldNames>
implements LifeCycle {
    public static final String IGNORE_FIELD_INDICATOR = "[ignore]";
    protected static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private final ThreadLocal<SoftReference<BufferRecycler>> recycler = new ThreadLocal<SoftReference<BufferRecycler>>(){

        @Override
        protected SoftReference<BufferRecycler> initialValue() {
            BufferRecycler bufferRecycler = new BufferRecycler();
            return new SoftReference<BufferRecycler>(bufferRecycler);
        }
    };
    private MappingJsonFactory jsonFactory = (MappingJsonFactory)new MappingJsonFactory().enable(JsonGenerator.Feature.ESCAPE_NON_ASCII);
    private JsonFactoryDecorator jsonFactoryDecorator = new NullJsonFactoryDecorator();
    private JsonGeneratorDecorator jsonGeneratorDecorator = new NullJsonGeneratorDecorator();
    protected FieldNamesType fieldNames;
    private volatile boolean started;
    protected final ContextAware contextAware;

    protected LogstashAbstractFormatter(ContextAware contextAware, FieldNamesType fieldNames) {
        this.contextAware = contextAware;
        this.fieldNames = fieldNames;
    }

    public void start() {
        this.jsonFactory = this.jsonFactoryDecorator.decorate(this.jsonFactory);
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] writeValueAsBytes(EventType event, Context context) throws IOException {
        ByteArrayBuilder outputStream = new ByteArrayBuilder(this.getBufferRecycler());
        try {
            this.writeValueToOutputStream(event, context, (OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            outputStream.release();
        }
    }

    public void writeValueToOutputStream(EventType event, Context context, OutputStream outputStream) throws IOException {
        JsonGenerator generator = this.createGenerator(outputStream);
        this.writeValueToGenerator(generator, event, context);
    }

    public String writeValueAsString(EventType event, Context context) throws IOException {
        SegmentedStringWriter writer = new SegmentedStringWriter(this.getBufferRecycler());
        JsonGenerator generator = this.createGenerator((Writer)writer);
        this.writeValueToGenerator(generator, event, context);
        return writer.getAndClear();
    }

    private JsonGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this.jsonGeneratorDecorator.decorate(this.jsonFactory.createGenerator(outputStream));
    }

    private JsonGenerator createGenerator(Writer writer) throws IOException {
        return this.jsonGeneratorDecorator.decorate(this.jsonFactory.createGenerator(writer));
    }

    protected abstract void writeValueToGenerator(JsonGenerator var1, EventType var2, Context var3) throws IOException;

    protected void writeMapEntries(JsonGenerator generator, Map<?, ?> map) throws IOException, JsonMappingException {
        if (map != null) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                generator.writeFieldName(entry.getKey().toString());
                generator.writeObject(entry.getValue());
            }
        }
    }

    protected void writeStringField(JsonGenerator generator, String fieldName, String fieldValue) throws IOException {
        if (this.shouldWriteField(fieldName) && this.shouldWriteField(fieldValue)) {
            generator.writeStringField(fieldName, fieldValue);
        }
    }

    protected void writeNumberField(JsonGenerator generator, String fieldName, int fieldValue) throws IOException {
        if (this.shouldWriteField(fieldName)) {
            generator.writeNumberField(fieldName, fieldValue);
        }
    }

    protected void writeNumberField(JsonGenerator generator, String fieldName, long fieldValue) throws IOException {
        if (this.shouldWriteField(fieldName)) {
            generator.writeNumberField(fieldName, fieldValue);
        }
    }

    private boolean shouldWriteField(String fieldName) {
        return fieldName != null && !fieldName.equals(IGNORE_FIELD_INDICATOR);
    }

    private BufferRecycler getBufferRecycler() {
        SoftReference<BufferRecycler> bufferRecyclerReference = this.recycler.get();
        BufferRecycler bufferRecycler = bufferRecyclerReference.get();
        if (bufferRecycler == null) {
            this.recycler.remove();
            return this.getBufferRecycler();
        }
        return bufferRecycler;
    }

    public FieldNamesType getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(FieldNamesType fieldNames) {
        this.fieldNames = fieldNames;
    }

    public JsonFactoryDecorator getJsonFactoryDecorator() {
        return this.jsonFactoryDecorator;
    }

    public void setJsonFactoryDecorator(JsonFactoryDecorator jsonFactoryDecorator) {
        this.jsonFactoryDecorator = jsonFactoryDecorator;
    }

    public JsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.jsonGeneratorDecorator;
    }

    public void setJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        this.jsonGeneratorDecorator = jsonGeneratorDecorator;
    }
}

