/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import net.logstash.logback.LogstashAbstractFormatter;
import net.logstash.logback.fieldnames.LogstashAccessFieldNames;

public class LogstashAccessFormatter
extends LogstashAbstractFormatter<IAccessEvent, LogstashAccessFieldNames> {
    public LogstashAccessFormatter(ContextAware contextAware) {
        super(contextAware, new LogstashAccessFieldNames());
    }

    @Override
    protected void writeValueToGenerator(JsonGenerator generator, IAccessEvent event, Context context) throws IOException {
        generator.writeStartObject();
        this.writeStringField(generator, ((LogstashAccessFieldNames)this.fieldNames).getTimestamp(), this.isoDateTimeTimeZoneFormatWithMillis.format(event.getTimeStamp()));
        this.writeNumberField(generator, ((LogstashAccessFieldNames)this.fieldNames).getVersion(), 1);
        this.writeStringField(generator, ((LogstashAccessFieldNames)this.fieldNames).getMessage(), String.format("%s - %s [%s] \"%s\" %s %s", event.getRemoteHost(), event.getRemoteUser() == null ? "-" : event.getRemoteUser(), this.isoDateTimeTimeZoneFormatWithMillis.format(event.getTimeStamp()), event.getRequestURL(), event.getStatusCode(), event.getContentLength()));
        this.writeFields(generator, event, context);
        generator.writeEndObject();
        generator.flush();
    }

    private void writeFields(JsonGenerator generator, IAccessEvent event, Context context) throws IOException {
        this.writeStringField(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsMethod(), event.getMethod());
        this.writeStringField(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsProtocol(), event.getProtocol());
        this.writeNumberField(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsStatusCode(), event.getStatusCode());
        this.writeStringField(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsRequestedUrl(), event.getRequestURL());
        this.writeStringField(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsRequestedUri(), event.getRequestURI());
        this.writeStringField(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsRemoteHost(), event.getRemoteHost());
        this.writeStringField(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsHostname(), event.getRemoteHost());
        this.writeStringField(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsRemoteUser(), event.getRemoteUser());
        this.writeNumberField(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsContentLength(), event.getContentLength());
        this.writeNumberField(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsElapsedTime(), event.getElapsedTime());
        this.writeMapStringFields(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsRequestHeaders(), event.getRequestHeaderMap());
        this.writeMapStringFields(generator, ((LogstashAccessFieldNames)this.fieldNames).getFieldsResponseHeaders(), event.getResponseHeaderMap());
        this.writeContextPropertiesIfNecessary(generator, context);
    }

    private void writeContextPropertiesIfNecessary(JsonGenerator generator, Context context) throws IOException {
        if (context != null) {
            this.writeMapEntries(generator, context.getCopyOfPropertyMap());
        }
    }
}

