/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.appender;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;

public abstract class AbstractLogstashTcpSocketAppender<E>
extends AppenderBase<E>
implements Runnable,
SocketConnector.ExceptionHandler {
    public static final int DEFAULT_PORT = 4560;
    public static final int DEFAULT_RECONNECTION_DELAY = 30000;
    public static final int DEFAULT_QUEUE_SIZE = 10000;
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 5000;
    private static final int DEFAULT_EVENT_DELAY_TIMEOUT = 100;
    private String remoteHost;
    private int port = 4560;
    private InetAddress address;
    private Duration reconnectionDelay = new Duration(30000L);
    private int acceptConnectionTimeout = 5000;
    private Duration eventDelayLimit = new Duration(100L);
    private int queueSize = 10000;
    private BlockingQueue<E> queue;
    private String peerId;
    private Future<?> task;
    private Future<Socket> connectorTask;
    private volatile Socket socket;
    protected Encoder<E> encoder;

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    protected void encoderInit(OutputStream outputStream) {
        if (this.encoder != null && outputStream != null) {
            try {
                this.encoder.init(outputStream);
            }
            catch (IOException ioe) {
                this.started = false;
                this.addStatus((Status)new ErrorStatus("Failed to initialize encoder for appender named [" + this.name + "].", (Object)this, (Throwable)ioe));
            }
        }
    }

    protected void encoderClose(OutputStream outputStream) {
        if (this.encoder != null && outputStream != null) {
            try {
                this.encoder.close();
            }
            catch (IOException ioe) {
                this.started = false;
                this.addStatus((Status)new ErrorStatus("Failed to write footer for appender named [" + this.name + "].", (Object)this, (Throwable)ioe));
            }
        }
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        int errorCount = 0;
        if (this.encoder == null) {
            ++errorCount;
            this.addError("No encoder was configured for appender " + this.name + ".");
        }
        if (this.port <= 0) {
            ++errorCount;
            this.addError("No port was configured for appender " + this.name + ". For more information, please visit http://logback.qos.ch/codes.html#socket_no_port");
        }
        if (this.remoteHost == null) {
            ++errorCount;
            this.addError("No remote host was configured for appender " + this.name + ". For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
        }
        if (errorCount == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException ex) {
                this.addError("unknown host: " + this.remoteHost);
                ++errorCount;
            }
        }
        if (errorCount == 0) {
            this.encoder.start();
            this.queue = new LinkedBlockingQueue(this.queueSize);
            this.peerId = "remote peer " + this.remoteHost + ":" + this.port + ": ";
            this.task = this.getContext().getExecutorService().submit(this);
            super.start();
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        CloseUtil.closeQuietly((Socket)this.socket);
        this.task.cancel(true);
        if (this.connectorTask != null) {
            this.connectorTask.cancel(true);
        }
        super.stop();
    }

    protected abstract void prepareForDeferredProcessing(E var1);

    protected void append(E event) {
        if (event == null || !this.isStarted()) {
            return;
        }
        try {
            this.prepareForDeferredProcessing(event);
            boolean inserted = this.queue.offer(event, this.eventDelayLimit.getMilliseconds(), TimeUnit.MILLISECONDS);
            if (!inserted) {
                this.addInfo("Dropping event due to timeout limit of [" + this.eventDelayLimit + "] being exceeded");
            }
        }
        catch (InterruptedException e) {
            this.addError("Interrupted while appending event to SocketAppender", e);
        }
    }

    @Override
    public final void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                SocketConnector connector = this.createConnector(this.address, this.port, 0, this.reconnectionDelay.getMilliseconds());
                this.connectorTask = this.activateConnector(connector);
                if (this.connectorTask != null) {
                    this.socket = this.waitForConnectorToReturnASocket();
                    if (this.socket != null) {
                        this.dispatchEvents();
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.addInfo("shutting down");
    }

    private SocketConnector createConnector(InetAddress address, int port, int initialDelay, long retryDelay) {
        SocketConnector connector = this.newConnector(address, port, initialDelay, retryDelay);
        connector.setExceptionHandler((SocketConnector.ExceptionHandler)this);
        connector.setSocketFactory(this.getSocketFactory());
        return connector;
    }

    private Future<Socket> activateConnector(SocketConnector connector) {
        try {
            return this.getContext().getExecutorService().submit(connector);
        }
        catch (RejectedExecutionException ex) {
            return null;
        }
    }

    private Socket waitForConnectorToReturnASocket() throws InterruptedException {
        try {
            Socket s = this.connectorTask.get();
            this.connectorTask = null;
            return s;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvents() throws InterruptedException {
        BufferedOutputStream outputStream = null;
        try {
            try {
                this.socket.setSoTimeout(this.acceptConnectionTimeout);
                outputStream = new BufferedOutputStream(this.socket.getOutputStream());
                this.encoderInit(outputStream);
                this.socket.setSoTimeout(0);
                this.addInfo(this.peerId + "connection established");
                int counter = 0;
                while (true) {
                    E event = this.queue.take();
                    this.encoder.doEncode(event);
                    ((OutputStream)outputStream).flush();
                    if (++counter < 70) continue;
                    ((OutputStream)outputStream).flush();
                    counter = 0;
                }
            }
            catch (IOException ex) {
                this.addInfo(this.peerId + "connection failed: " + ex);
                if (outputStream != null) {
                    this.encoderClose(outputStream);
                }
                CloseUtil.closeQuietly((Socket)this.socket);
                this.socket = null;
                this.addInfo(this.peerId + "connection closed");
            }
        }
        catch (Throwable throwable) {
            if (outputStream != null) {
                this.encoderClose(outputStream);
            }
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
            this.addInfo(this.peerId + "connection closed");
            throw throwable;
        }
    }

    public void connectionFailed(SocketConnector connector, Exception ex) {
        if (ex instanceof InterruptedException) {
            this.addInfo("connector interrupted");
        } else if (ex instanceof ConnectException) {
            this.addInfo(this.peerId + "connection refused");
        } else {
            this.addInfo(this.peerId + ex);
        }
    }

    protected SocketConnector newConnector(InetAddress address, int port, long initialDelay, long retryDelay) {
        return new DefaultSocketConnector(address, port, initialDelay, retryDelay);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(Duration delay) {
        this.reconnectionDelay = delay;
    }

    public Duration getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setEventDelayLimit(Duration eventDelayLimit) {
        this.eventDelayLimit = eventDelayLimit;
    }

    public Duration getEventDelayLimit() {
        return this.eventDelayLimit;
    }

    void setAcceptConnectionTimeout(int acceptConnectionTimeout) {
        this.acceptConnectionTimeout = acceptConnectionTimeout;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        if (this.queue != null) {
            throw new IllegalStateException("Queue size must be set before initialization");
        }
        this.queueSize = queueSize;
    }
}

