/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.spi.ContextAware;
import java.io.IOException;
import net.logstash.logback.LogstashAccessFormatter;
import net.logstash.logback.decorate.JsonFactoryDecorator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import net.logstash.logback.encoder.org.apache.commons.io.IOUtils;
import net.logstash.logback.fieldnames.LogstashAccessFieldNames;

public class LogstashAccessEncoder
extends EncoderBase<IAccessEvent> {
    private boolean immediateFlush = true;
    private final LogstashAccessFormatter formatter = new LogstashAccessFormatter((ContextAware)this);

    public void doEncode(IAccessEvent event) throws IOException {
        IOUtils.write(this.formatter.writeValueAsBytes(event, this.getContext()), this.outputStream);
        IOUtils.write(CoreConstants.LINE_SEPARATOR, this.outputStream);
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    public void start() {
        super.start();
        this.formatter.start();
    }

    public void stop() {
        super.stop();
        this.formatter.stop();
    }

    public void close() throws IOException {
        IOUtils.write(IOUtils.LINE_SEPARATOR, this.outputStream);
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public LogstashAccessFieldNames getFieldNames() {
        return (LogstashAccessFieldNames)this.formatter.getFieldNames();
    }

    public void setFieldNames(LogstashAccessFieldNames fieldNames) {
        this.formatter.setFieldNames(fieldNames);
    }

    public JsonFactoryDecorator getJsonFactoryDecorator() {
        return this.formatter.getJsonFactoryDecorator();
    }

    public void setJsonFactoryDecorator(JsonFactoryDecorator jsonFactoryDecorator) {
        this.formatter.setJsonFactoryDecorator(jsonFactoryDecorator);
    }

    public JsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.formatter.getJsonGeneratorDecorator();
    }

    public void setJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        this.formatter.setJsonGeneratorDecorator(jsonGeneratorDecorator);
    }

    public String getTimeZone() {
        return this.formatter.getTimeZone();
    }

    public void setTimeZone(String timeZoneId) {
        this.formatter.setTimeZone(timeZoneId);
    }
}

