/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.appender;

import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.logstash.logback.appender.WaitStrategyFactory;
import net.logstash.logback.encoder.com.lmax.disruptor.BlockingWaitStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.EventFactory;
import net.logstash.logback.encoder.com.lmax.disruptor.EventHandler;
import net.logstash.logback.encoder.com.lmax.disruptor.EventTranslatorOneArg;
import net.logstash.logback.encoder.com.lmax.disruptor.ExceptionHandler;
import net.logstash.logback.encoder.com.lmax.disruptor.LifecycleAware;
import net.logstash.logback.encoder.com.lmax.disruptor.TimeoutException;
import net.logstash.logback.encoder.com.lmax.disruptor.WaitStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.dsl.Disruptor;
import net.logstash.logback.encoder.com.lmax.disruptor.dsl.ProducerType;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public abstract class AsyncDisruptorAppender<Event extends DeferredProcessingAware>
extends UnsynchronizedAppenderBase<Event> {
    protected static final String APPENDER_NAME_FORMAT = "%1$s";
    protected static final String THREAD_INDEX_FORMAT = "%2$d";
    public static final String DEFAULT_THREAD_NAME_FORMAT = "logback-appender-%1$s-%2$d";
    public static final int DEFAULT_RING_BUFFER_SIZE = 8192;
    public static final ProducerType DEFAULT_PRODUCER_TYPE = ProducerType.MULTI;
    public static final WaitStrategy DEFAULT_WAIT_STRATEGY = new BlockingWaitStrategy();
    public static final int DEFAULT_DROPPED_WARN_FREQUENCY = 1000;
    private int ringBufferSize = 8192;
    private ProducerType producerType = DEFAULT_PRODUCER_TYPE;
    private WaitStrategy waitStrategy = DEFAULT_WAIT_STRATEGY;
    private String threadNameFormat = "logback-appender-%1$s-%2$d";
    private boolean useDaemonThread = true;
    private int droppedWarnFrequency = 1000;
    private ThreadFactory threadFactory = new WorkerThreadFactory();
    private ScheduledThreadPoolExecutor executorService;
    private int threadPoolCoreSize = 1;
    private Disruptor<LogEvent<Event>> disruptor;
    private EventTranslatorOneArg<LogEvent<Event>, Event> eventTranslator = new LogEventTranslator();
    private EventHandler<LogEvent<Event>> eventHandler;
    private ExceptionHandler<LogEvent<Event>> exceptionHandler = new LogEventExceptionHandler();
    private final AtomicLong consecutiveDroppedCount = new AtomicLong();
    private LogEventFactory<Event> eventFactory = new LogEventFactory();
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    public void start() {
        if (this.eventHandler == null) {
            this.addError("No eventHandler was configured for appender " + this.name + ".");
            return;
        }
        this.executorService = new ScheduledThreadPoolExecutor(this.getThreadPoolCoreSize(), this.threadFactory);
        this.setRemoveOnCancelPolicy();
        this.disruptor = new Disruptor<Event>(this.eventFactory, this.ringBufferSize, this.executorService, this.producerType, this.waitStrategy);
        this.disruptor.handleExceptionsWith(this.exceptionHandler);
        this.disruptor.handleEventsWith(new EventClearingEventHandler<Event>(this.eventHandler));
        this.disruptor.start();
        super.start();
    }

    public void stop() {
        if (!super.isStarted()) {
            return;
        }
        super.stop();
        try {
            this.disruptor.shutdown(1L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            this.addWarn("Some queued events have not been logged due to requested shutdown");
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.addWarn("Some queued events have not been logged due to requested shutdown");
            }
        }
        catch (InterruptedException e) {
            this.addWarn("Some queued events have not been logged due to requested shutdown", e);
        }
    }

    protected void append(Event event) {
        this.prepareForDeferredProcessing(event);
        if (!this.disruptor.getRingBuffer().tryPublishEvent(this.eventTranslator, event)) {
            long consecutiveDropped = this.consecutiveDroppedCount.incrementAndGet();
            if (consecutiveDropped % (long)this.droppedWarnFrequency == 1L) {
                this.addWarn("Dropped " + consecutiveDropped + " events (and counting...) due to ring buffer at max capacity [" + this.ringBufferSize + "]");
            }
        } else {
            long consecutiveDropped = this.consecutiveDroppedCount.get();
            if (consecutiveDropped != 0L && this.consecutiveDroppedCount.compareAndSet(consecutiveDropped, 0L)) {
                this.addWarn("Dropped " + consecutiveDropped + " total events due to ring buffer at max capacity [" + this.ringBufferSize + "]");
            }
        }
    }

    protected void prepareForDeferredProcessing(Event event) {
        event.prepareForDeferredProcessing();
    }

    @IgnoreJRERequirement
    private void setRemoveOnCancelPolicy() {
        if (this.isRemoveOnCancelPolicyPossible()) {
            this.executorService.setRemoveOnCancelPolicy(true);
        }
    }

    private boolean isRemoveOnCancelPolicyPossible() {
        try {
            ScheduledThreadPoolExecutor.class.getMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    protected String calculateThreadName() {
        List<Object> threadNameFormatParams = this.getThreadNameFormatParams();
        return String.format(this.threadNameFormat, threadNameFormatParams.toArray(new Object[threadNameFormatParams.size()]));
    }

    protected List<Object> getThreadNameFormatParams() {
        return Arrays.asList(this.getName(), this.threadNumber.incrementAndGet());
    }

    protected void setEventFactory(LogEventFactory<Event> eventFactory) {
        this.eventFactory = eventFactory;
    }

    protected EventTranslatorOneArg<LogEvent<Event>, Event> getEventTranslator() {
        return this.eventTranslator;
    }

    protected void setEventTranslator(EventTranslatorOneArg<LogEvent<Event>, Event> eventTranslator) {
        this.eventTranslator = eventTranslator;
    }

    protected ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    protected Disruptor<LogEvent<Event>> getDisruptor() {
        return this.disruptor;
    }

    protected int getThreadPoolCoreSize() {
        return this.threadPoolCoreSize;
    }

    protected void setThreadPoolCoreSize(int threadPoolCoreSize) {
        this.threadPoolCoreSize = threadPoolCoreSize;
    }

    @Deprecated
    public String getThreadNamePrefix() {
        if (this.threadNameFormat != null && this.threadNameFormat.endsWith(THREAD_INDEX_FORMAT)) {
            return this.threadNameFormat.substring(0, this.threadNameFormat.length() - THREAD_INDEX_FORMAT.length());
        }
        return this.threadNameFormat;
    }

    @Deprecated
    public void setThreadNamePrefix(String threadNamePrefix) {
        this.setThreadNameFormat(threadNamePrefix + THREAD_INDEX_FORMAT);
    }

    public String getThreadNameFormat() {
        return this.threadNameFormat;
    }

    public void setThreadNameFormat(String threadNameFormat) {
        this.threadNameFormat = threadNameFormat;
    }

    public int getRingBufferSize() {
        return this.ringBufferSize;
    }

    public void setRingBufferSize(int ringBufferSize) {
        this.ringBufferSize = ringBufferSize;
    }

    public ProducerType getProducerType() {
        return this.producerType;
    }

    public void setProducerType(ProducerType producerType) {
        this.producerType = producerType;
    }

    public WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public void setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    public void setWaitStrategyType(String waitStrategyType) {
        this.setWaitStrategy(WaitStrategyFactory.createWaitStrategyFromString(waitStrategyType));
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public int getDroppedWarnFrequency() {
        return this.droppedWarnFrequency;
    }

    public void setDroppedWarnFrequency(int droppedWarnFrequency) {
        this.droppedWarnFrequency = droppedWarnFrequency;
    }

    protected EventHandler<LogEvent<Event>> getEventHandler() {
        return this.eventHandler;
    }

    protected void setEventHandler(EventHandler<LogEvent<Event>> eventHandler) {
        this.eventHandler = eventHandler;
    }

    public boolean isDaemon() {
        return this.useDaemonThread;
    }

    public void setDaemon(boolean useDaemonThread) {
        this.useDaemonThread = useDaemonThread;
    }

    private static class EventClearingEventHandler<Event>
    implements EventHandler<LogEvent<Event>>,
    LifecycleAware {
        private final EventHandler<LogEvent<Event>> delegate;

        public EventClearingEventHandler(EventHandler<LogEvent<Event>> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(LogEvent<Event> event, long sequence, boolean endOfBatch) throws Exception {
            try {
                this.delegate.onEvent(event, sequence, endOfBatch);
            }
            finally {
                event.event = null;
            }
        }

        @Override
        public void onStart() {
            if (this.delegate instanceof LifecycleAware) {
                ((LifecycleAware)((Object)this.delegate)).onStart();
            }
        }

        @Override
        public void onShutdown() {
            if (this.delegate instanceof LifecycleAware) {
                ((LifecycleAware)((Object)this.delegate)).onShutdown();
            }
        }
    }

    private class LogEventExceptionHandler
    implements ExceptionHandler<LogEvent<Event>> {
        private LogEventExceptionHandler() {
        }

        @Override
        public void handleEventException(Throwable ex, long sequence, LogEvent<Event> event) {
            AsyncDisruptorAppender.this.addError("Unable to process event: " + ex.getMessage(), ex);
        }

        @Override
        public void handleOnStartException(Throwable ex) {
            AsyncDisruptorAppender.this.addError("Unable start disruptor", ex);
        }

        @Override
        public void handleOnShutdownException(Throwable ex) {
            AsyncDisruptorAppender.this.addError("Unable shutdown disruptor", ex);
        }
    }

    protected static class LogEventTranslator<Event>
    implements EventTranslatorOneArg<LogEvent<Event>, Event> {
        protected LogEventTranslator() {
        }

        @Override
        public void translateTo(LogEvent<Event> logEvent, long sequence, Event event) {
            logEvent.event = event;
        }
    }

    private class WorkerThreadFactory
    implements ThreadFactory {
        private WorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(AsyncDisruptorAppender.this.calculateThreadName());
            t.setDaemon(AsyncDisruptorAppender.this.useDaemonThread);
            return t;
        }
    }

    private static class LogEventFactory<Event>
    implements EventFactory<LogEvent<Event>> {
        private LogEventFactory() {
        }

        @Override
        public LogEvent<Event> newInstance() {
            return new LogEvent();
        }
    }

    protected static class LogEvent<Event> {
        public volatile Event event;

        protected LogEvent() {
        }
    }
}

