/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.googlecode.totallylazy.Function1;
import com.googlecode.totallylazy.Option;
import com.googlecode.totallylazy.Sequence;
import com.googlecode.totallylazy.Sequences;
import java.util.ArrayList;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringUtils;

public class Element {
    private String name;
    private String description;
    private String keyword;
    private Step[] steps;
    private Tag[] tags;

    public Sequence<Step> getSteps() {
        return Sequences.sequence((Object[])((Object[])Option.option((Object)this.steps).getOrElse((Object)new Step[0]))).realise();
    }

    public Sequence<Tag> getTags() {
        return Sequences.sequence((Object[])((Object[])Option.option((Object)this.tags).getOrElse((Object)new Tag[0]))).realise();
    }

    public Util.Status getStatus() {
        Sequence results = this.getSteps().filter(Step.predicates.hasStatus(Util.Status.FAILED));
        return results.size() == 0 ? Util.Status.PASSED : Util.Status.FAILED;
    }

    public String getRawName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getName() {
        ArrayList<String> contentString = new ArrayList<String>();
        if (Util.itemExists(this.keyword)) {
            contentString.add("<span class=\"scenario-keyword\">" + this.keyword + ": </span>");
        }
        if (Util.itemExists(this.name)) {
            contentString.add("<span class=\"scenario-name\">" + this.name + "</span>");
        }
        return Util.itemExists(contentString) ? Util.result(this.getStatus()) + StringUtils.join((Object[])contentString.toArray(), (String)" ") + Util.closeDiv() : "";
    }

    public Sequence<String> getTagList() {
        return this.processTags();
    }

    public boolean hasTags() {
        return Util.itemExists(this.tags);
    }

    private Sequence<String> processTags() {
        return this.getTags().map(Tag.functions.getName());
    }

    public String getTagsList() {
        String result = "<div class=\"feature-tags\"></div>";
        if (Util.itemExists(this.tags)) {
            String tagList = StringUtils.join((Object[])this.processTags().toList().toArray(), (String)",");
            result = "<div class=\"feature-tags\">" + tagList + "</div>";
        }
        return result;
    }

    public static class functions {
        public static Function1<Element, Util.Status> status() {
            return new Function1<Element, Util.Status>(){

                public Util.Status call(Element element) throws Exception {
                    return element.getStatus();
                }
            };
        }
    }
}

