/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.googlecode.totallylazy.Sequence;
import com.googlecode.totallylazy.Sequences;
import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringUtils;

public class Feature {
    private String name;
    private String uri;
    private String description;
    private String keyword;
    private Element[] elements;
    private Tag[] tags;
    private StepResults stepResults;
    private ScenarioResults scenarioResults;

    public Sequence<Element> getElements() {
        return Sequences.sequence((Object[])this.elements).realise();
    }

    public String getFileName() {
        ArrayList<String> matches = new ArrayList<String>();
        for (String line : Splitter.onPattern((String)"/|\\\\").split((CharSequence)this.uri)) {
            String modified = line.replaceAll("\\)|\\(", "");
            modified = StringUtils.deleteWhitespace((String)modified).trim();
            matches.add(modified);
        }
        List sublist = matches.subList(1, matches.size());
        matches = sublist.size() == 0 ? matches : sublist;
        String fileName = Joiner.on((String)"-").join(matches) + ".html";
        return fileName;
    }

    public boolean hasTags() {
        return Util.itemExists(this.tags);
    }

    public Sequence<String> getTagList() {
        return this.getTags().map(Tag.functions.getName());
    }

    public Sequence<Tag> getTags() {
        return Sequences.sequence((Object[])this.tags).realise();
    }

    public String getTagsList() {
        String result = "<div class=\"feature-tags\"></div>";
        if (Util.itemExists(this.tags)) {
            String tagList = StringUtils.join((Object[])this.getTagList().toList().toArray(), (String)",");
            result = "<div class=\"feature-tags\">" + tagList + "</div>";
        }
        return result;
    }

    public Util.Status getStatus() {
        Sequence results = this.getElements().map(Element.functions.status());
        return results.contains((Object)Util.Status.FAILED) ? Util.Status.FAILED : Util.Status.PASSED;
    }

    public String getName() {
        return Util.itemExists(this.name) ? Util.result(this.getStatus()) + "<div class=\"feature-line\"><span class=\"feature-keyword\">" + this.keyword + ":</span> " + this.name + "</div>" + Util.closeDiv() : "";
    }

    public String getRawName() {
        return Util.itemExists(this.name) ? this.name : "";
    }

    public String getRawStatus() {
        return this.getStatus().toString().toLowerCase();
    }

    public String getDescription() {
        String result = "";
        if (Util.itemExists(this.description)) {
            String content = this.description.replaceFirst("As an", "<span class=\"feature-role\">As an</span>");
            content = content.replaceFirst("I want to", "<span class=\"feature-action\">I want to</span>");
            content = content.replaceFirst("So that", "<span class=\"feature-value\">So that</span>");
            content = content.replaceAll("\n", "<br/>");
            result = "<div class=\"feature-description\">" + content + "</div>";
        }
        return result;
    }

    public int getNumberOfScenarios() {
        int result = 0;
        if (Util.itemExists(this.elements)) {
            ArrayList<Element> elementList = new ArrayList<Element>();
            for (Element element : this.elements) {
                if (element.getKeyword().equals("Background")) continue;
                elementList.add(element);
            }
            result = elementList.size();
        }
        return result;
    }

    public int getNumberOfSteps() {
        return this.stepResults.getNumberOfSteps();
    }

    public int getNumberOfPasses() {
        return this.stepResults.getNumberOfPasses();
    }

    public int getNumberOfFailures() {
        return this.stepResults.getNumberOfFailures();
    }

    public int getNumberOfPending() {
        return this.stepResults.getNumberOfPending();
    }

    public int getNumberOfSkipped() {
        return this.stepResults.getNumberOfSkipped();
    }

    public int getNumberOfMissing() {
        return this.stepResults.getNumberOfMissing();
    }

    public int getNumberOfUndefined() {
        return this.stepResults.getNumberOfUndefined();
    }

    public String getDurationOfSteps() {
        return this.stepResults.getTotalDurationAsString();
    }

    public int getNumberOfScenariosPassed() {
        return this.scenarioResults.getNumberOfScenariosPassed();
    }

    public int getNumberOfScenariosFailed() {
        return this.scenarioResults.getNumberOfScenariosFailed();
    }

    public void processSteps() {
        ArrayList<Step> allSteps = new ArrayList<Step>();
        List<Step> passedSteps = new ArrayList<Step>();
        List<Step> failedSteps = new ArrayList<Step>();
        List<Step> skippedSteps = new ArrayList<Step>();
        List<Step> undefinedSteps = new ArrayList<Step>();
        List<Step> pendingSteps = new ArrayList<Step>();
        List<Step> missingSteps = new ArrayList<Step>();
        ArrayList<Element> passedScenarios = new ArrayList<Element>();
        ArrayList<Element> failedScenarios = new ArrayList<Element>();
        Long totalDuration = 0L;
        if (Util.itemExists(this.elements)) {
            for (Element element : this.elements) {
                this.calculateScenarioStats(passedScenarios, failedScenarios, element);
                if (!Util.hasSteps(element)) continue;
                Sequence<Step> steps = element.getSteps();
                for (Step step : steps) {
                    allSteps.add(step);
                    Util.Status stepStatus = step.getStatus();
                    passedSteps = Util.setStepStatus(passedSteps, step, stepStatus, Util.Status.PASSED);
                    failedSteps = Util.setStepStatus(failedSteps, step, stepStatus, Util.Status.FAILED);
                    skippedSteps = Util.setStepStatus(skippedSteps, step, stepStatus, Util.Status.SKIPPED);
                    undefinedSteps = Util.setStepStatus(undefinedSteps, step, stepStatus, Util.Status.UNDEFINED);
                    pendingSteps = Util.setStepStatus(pendingSteps, step, stepStatus, Util.Status.PENDING);
                    missingSteps = Util.setStepStatus(missingSteps, step, stepStatus, Util.Status.MISSING);
                    totalDuration = totalDuration + step.getDuration();
                }
            }
        }
        this.scenarioResults = new ScenarioResults(passedScenarios, failedScenarios);
        this.stepResults = new StepResults(allSteps, passedSteps, failedSteps, skippedSteps, pendingSteps, missingSteps, undefinedSteps, totalDuration);
    }

    private void calculateScenarioStats(List<Element> passedScenarios, List<Element> failedScenarios, Element element) {
        if (!element.getKeyword().equals("Background")) {
            if (element.getStatus() == Util.Status.PASSED) {
                passedScenarios.add(element);
            } else if (element.getStatus() == Util.Status.FAILED) {
                failedScenarios.add(element);
            }
        }
    }

    class ScenarioResults {
        List<Element> passedScenarios;
        List<Element> failedScenarios;

        ScenarioResults(List<Element> passedScenarios, List<Element> failedScenarios) {
            this.passedScenarios = passedScenarios;
            this.failedScenarios = failedScenarios;
        }

        public int getNumberOfScenariosPassed() {
            return this.passedScenarios.size();
        }

        public int getNumberOfScenariosFailed() {
            return this.failedScenarios.size();
        }
    }

    class StepResults {
        List<Step> allSteps;
        List<Step> passedSteps;
        List<Step> failedSteps;
        List<Step> skippedSteps;
        List<Step> undefinedSteps;
        List<Step> pendingSteps;
        List<Step> missingSteps;
        Long totalDuration;

        public StepResults(List<Step> allSteps, List<Step> passedSteps, List<Step> failedSteps, List<Step> skippedSteps, List<Step> pendingSteps, List<Step> missingSteps, List<Step> undefinedSteps, Long totalDuration) {
            this.allSteps = allSteps;
            this.passedSteps = passedSteps;
            this.failedSteps = failedSteps;
            this.skippedSteps = skippedSteps;
            this.undefinedSteps = undefinedSteps;
            this.pendingSteps = pendingSteps;
            this.missingSteps = missingSteps;
            this.totalDuration = totalDuration;
        }

        public int getNumberOfSteps() {
            return this.allSteps.size();
        }

        public int getNumberOfPasses() {
            return this.passedSteps.size();
        }

        public int getNumberOfFailures() {
            return this.failedSteps.size();
        }

        public int getNumberOfUndefined() {
            return this.undefinedSteps.size();
        }

        public int getNumberOfPending() {
            return this.pendingSteps.size();
        }

        public int getNumberOfSkipped() {
            return this.skippedSteps.size();
        }

        public int getNumberOfMissing() {
            return this.missingSteps.size();
        }

        public long getTotalDuration() {
            return this.totalDuration;
        }

        public String getTotalDurationAsString() {
            return Util.formatDuration(this.totalDuration);
        }
    }
}

