/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UnzipUtils {
    private static final int BUFFER_SIZE = 2048;
    private static final String ZIP_EXTENSION = ".zip";

    public static void unzipToFile(File srcZipFile, File destDirectory) {
        try {
            BufferedInputStream bufIS = null;
            destDirectory.mkdirs();
            ZipFile zipFile = new ZipFile(srcZipFile, 1);
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            while (zipFileEntries.hasMoreElements()) {
                int currentByte;
                ZipEntry entry = zipFileEntries.nextElement();
                File destFile = new File(destDirectory, entry.getName());
                File parentDestFile = destFile.getParentFile();
                parentDestFile.mkdirs();
                if (entry.isDirectory()) continue;
                bufIS = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] data = new byte[2048];
                FileOutputStream fOS = new FileOutputStream(destFile);
                BufferedOutputStream bufOS = new BufferedOutputStream(fOS, 2048);
                while ((currentByte = bufIS.read(data, 0, 2048)) != -1) {
                    bufOS.write(data, 0, currentByte);
                }
                bufOS.flush();
                bufOS.close();
                if (!entry.getName().toLowerCase().endsWith(ZIP_EXTENSION)) continue;
                String zipFilePath = destDirectory.getPath() + File.separatorChar + entry.getName();
                UnzipUtils.unzipToFile(new File(zipFilePath), new File(zipFilePath.substring(0, zipFilePath.length() - ZIP_EXTENSION.length())));
            }
            bufIS.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

