/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.googlecode.totallylazy.Sequence;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.masterthought.cucumber.Background;
import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.ScenarioTag;
import net.masterthought.cucumber.TagObject;
import net.masterthought.cucumber.json.Artifact;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.util.Status;
import net.masterthought.cucumber.util.StatusCounter;
import net.masterthought.cucumber.util.Util;

public class ReportInformation {
    private final Map<String, List<Feature>> projectFeatureMap;
    private List<Feature> features;
    private int numberOfScenarios;
    private int numberOfSteps;
    private final StatusCounter totalSteps = new StatusCounter();
    private final StatusCounter totalBackgroundSteps = new StatusCounter();
    private Long totalDuration = 0L;
    List<TagObject> tagMap = new ArrayList<TagObject>();
    private int totalTagScenarios = 0;
    private int totalTagSteps = 0;
    private final StatusCounter totalTags = new StatusCounter();
    private long totalTagDuration = 0L;
    private int totalPassingTagScenarios = 0;
    private int totalFailingTagScenarios = 0;
    private Background backgroundInfo = new Background();

    public ReportInformation(Map<String, List<Feature>> projectFeatureMap) {
        this.projectFeatureMap = projectFeatureMap;
        this.features = this.listAllFeatures();
        this.processFeatures();
    }

    private List<Feature> listAllFeatures() {
        ArrayList<Feature> allFeatures = new ArrayList<Feature>();
        for (Map.Entry<String, List<Feature>> pairs : this.projectFeatureMap.entrySet()) {
            List<Feature> featureList = pairs.getValue();
            allFeatures.addAll(featureList);
        }
        return allFeatures;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<TagObject> getTags() {
        return this.tagMap;
    }

    public Map<String, List<Feature>> getProjectFeatureMap() {
        return this.projectFeatureMap;
    }

    public int getTotalScenarios() {
        return this.numberOfScenarios;
    }

    public int getTotalFeatures() {
        return this.features.size();
    }

    public int getTotalSteps() {
        return this.numberOfSteps;
    }

    public int getTotalStepsPassed() {
        return this.totalSteps.getValueFor(Status.PASSED);
    }

    public int getTotalStepsFailed() {
        return this.totalSteps.getValueFor(Status.FAILED);
    }

    public int getTotalStepsSkipped() {
        return this.totalSteps.getValueFor(Status.SKIPPED);
    }

    public int getTotalStepsPending() {
        return this.totalSteps.getValueFor(Status.PENDING);
    }

    public int getTotalStepsMissing() {
        return this.totalSteps.getValueFor(Status.MISSING);
    }

    public int getTotalStepsUndefined() {
        return this.totalSteps.getValueFor(Status.UNDEFINED);
    }

    public String getTotalDurationAsString() {
        return Util.formatDuration(this.totalDuration);
    }

    public Long getTotalDuration() {
        return this.totalDuration;
    }

    public String timeStamp() {
        return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date());
    }

    public String getReportStatusColour(Feature feature) {
        return feature.getStatus() == Status.PASSED ? Status.PASSED.color : Status.FAILED.color;
    }

    public String getTagReportStatusColour(TagObject tag) {
        return tag.getStatus() == Status.PASSED ? Status.PASSED.color : Status.FAILED.color;
    }

    public int getTotalTags() {
        return this.tagMap.size();
    }

    public int getTotalTagScenarios() {
        return this.totalTagScenarios;
    }

    public int getTotalTagScenariosPassed() {
        return this.totalPassingTagScenarios;
    }

    public int getTotalTagScenariosFailed() {
        return this.totalFailingTagScenarios;
    }

    public int getTotalTagSteps() {
        return this.totalTagSteps;
    }

    public int getTotalTagPasses() {
        return this.totalTags.getValueFor(Status.PASSED);
    }

    public int getTotalTagFails() {
        return this.totalTags.getValueFor(Status.FAILED);
    }

    public int getTotalTagSkipped() {
        return this.totalTags.getValueFor(Status.SKIPPED);
    }

    public int getTotalTagPending() {
        return this.totalTags.getValueFor(Status.PENDING);
    }

    public int getTotalTagUndefined() {
        return this.totalTags.getValueFor(Status.UNDEFINED);
    }

    public int getTotalTagMissing() {
        return this.totalTags.getValueFor(Status.MISSING);
    }

    public String getTotalTagDuration() {
        return Util.formatDuration(this.totalTagDuration);
    }

    public long getLongTotalTagDuration() {
        return this.totalTagDuration;
    }

    public int getTotalScenariosPassed() {
        return this.totalBackgroundSteps.getValueFor(Status.PASSED);
    }

    public int getTotalScenariosFailed() {
        return this.totalBackgroundSteps.getValueFor(Status.FAILED);
    }

    private void processTags() {
        for (TagObject tag : this.tagMap) {
            this.totalTagScenarios = this.calculateTotalTagScenarios(tag);
            this.totalPassingTagScenarios = this.calculateTotalTagScenariosForStatus(this.totalPassingTagScenarios, tag, Status.PASSED);
            this.totalFailingTagScenarios = this.calculateTotalTagScenariosForStatus(this.totalFailingTagScenarios, tag, Status.FAILED);
            for (Status status : Status.values()) {
                this.totalTags.incrementFor(status, tag.getNumberOfStatus(status));
            }
            for (ScenarioTag scenarioTag : tag.getScenarios()) {
                if (!scenarioTag.hasSteps()) continue;
                Sequence<Step> steps = scenarioTag.getScenario().getSteps();
                ArrayList<Step> stepList = new ArrayList<Step>();
                for (Step step : steps) {
                    stepList.add(step);
                    this.totalTagDuration += step.getDuration().longValue();
                }
                this.totalTagSteps += stepList.size();
            }
        }
    }

    private int calculateTotalTagScenariosForStatus(int totalScenarios, TagObject tag, Status status) {
        ArrayList<ScenarioTag> scenarioTagList = new ArrayList<ScenarioTag>();
        for (ScenarioTag scenarioTag : tag.getScenarios()) {
            if (scenarioTag.getScenario().isBackground() || !scenarioTag.getScenario().getStatus().equals((Object)status)) continue;
            scenarioTagList.add(scenarioTag);
        }
        return totalScenarios + scenarioTagList.size();
    }

    private int calculateTotalTagScenarios(TagObject tag) {
        ArrayList<ScenarioTag> scenarioTagList = new ArrayList<ScenarioTag>();
        for (ScenarioTag scenarioTag : tag.getScenarios()) {
            if (scenarioTag.getScenario().isBackground()) continue;
            scenarioTagList.add(scenarioTag);
        }
        return this.totalTagScenarios + scenarioTagList.size();
    }

    private void processFeatures() {
        for (Feature feature : this.features) {
            List<ScenarioTag> scenarioList = new ArrayList<ScenarioTag>();
            Sequence<Element> scenarios = feature.getElements();
            if (!Util.itemExists(scenarios)) continue;
            this.numberOfScenarios = this.getNumberOfScenarios(scenarios);
            if (feature.hasTags()) {
                for (Element e : feature.getElements()) {
                    if (e.isBackground()) continue;
                    scenarioList.add(new ScenarioTag(e, feature.getFileName()));
                }
                this.tagMap = this.createOrAppendToTagMapByFeature(this.tagMap, feature.getTagList(), scenarioList);
            }
            for (Element scenario : scenarios) {
                if (!scenario.isBackground()) {
                    this.totalBackgroundSteps.incrementFor(scenario.getStatus());
                } else {
                    this.setBackgroundInfo(scenario);
                }
                if (feature.hasScenarios() && scenario.hasTags()) {
                    scenarioList = this.addScenarioUnlessExists(scenarioList, new ScenarioTag(scenario, feature.getFileName()));
                    this.tagMap = this.createOrAppendToTagMap(this.tagMap, scenario.getTagList(), scenarioList);
                }
                this.adjustStepsForScenario(scenario);
            }
        }
        this.processTags();
    }

    private void setBackgroundInfo(Element e) {
        this.backgroundInfo.addTotalScenarios(1);
        if (e.getStatus() == Status.PASSED) {
            this.backgroundInfo.addTotalScenariosPassed(1);
        } else {
            this.backgroundInfo.addTotalScenariosFailed(1);
        }
        this.backgroundInfo.addTotalSteps(e.getSteps().size());
        for (Step step : e.getSteps().toList()) {
            this.backgroundInfo.incrTotalDurationBy(step.getDuration());
            this.backgroundInfo.incrStepCounterForStatus(step.getStatus());
        }
    }

    private void adjustStepsForScenario(Element element) {
        String scenarioName = element.getRawName();
        if (element.hasSteps()) {
            Sequence<Step> steps = element.getSteps();
            this.numberOfSteps += steps.size();
            for (Step step : steps) {
                String mapKey;
                Map<String, Artifact> map;
                String stepName = step.getRawName();
                ConfigurationOptions configuration = ConfigurationOptions.instance();
                if (configuration.artifactsEnabled() && (map = configuration.artifactConfig()).containsKey(mapKey = scenarioName + stepName)) {
                    Artifact artifact = map.get(mapKey);
                    String keyword = artifact.getKeyword();
                    String contentType = artifact.getContentType();
                    step.setName(stepName.replaceFirst(keyword, this.getArtifactFile(mapKey, keyword, artifact.getArtifactFile(), contentType)));
                }
                this.totalSteps.incrementFor(step.getStatus());
                this.totalDuration = this.totalDuration + step.getDuration();
            }
        }
    }

    private int getNumberOfScenarios(Sequence<Element> scenarios) {
        ArrayList<Element> scenarioList = new ArrayList<Element>();
        for (Element scenario : scenarios) {
            if (scenario.isBackground()) continue;
            scenarioList.add(scenario);
        }
        return this.numberOfScenarios + scenarioList.size();
    }

    private String getArtifactFile(String mapKey, String keyword, String artifactFile, String contentType) {
        mapKey = mapKey.replaceAll(" ", "_");
        String link = "";
        link = contentType.equals("xml") ? "<div style=\"display:none;\"><textarea id=\"" + mapKey + "\" class=\"brush: xml;\"></textarea></div><a onclick=\"applyArtifact('" + mapKey + "','" + artifactFile + "')\" href=\"#\">" + keyword + "</a>" : "<div style=\"display:none;\"><textarea id=\"" + mapKey + "\"></textarea></div><script>\\$('#" + mapKey + "').load('" + artifactFile + "')</script><a onclick=\"\\$('#" + mapKey + "').dialog();\" href=\"#\">" + keyword + "</a>";
        return link;
    }

    private List<ScenarioTag> addScenarioUnlessExists(List<ScenarioTag> scenarioList, ScenarioTag scenarioTag) {
        boolean exists = false;
        for (ScenarioTag scenario : scenarioList) {
            if (!scenario.getParentFeatureUri().equalsIgnoreCase(scenarioTag.getParentFeatureUri()) || !scenario.getScenario().getName().equalsIgnoreCase(scenarioTag.getScenario().getName())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            scenarioList.add(scenarioTag);
        }
        return scenarioList;
    }

    private List<TagObject> createOrAppendToTagMap(List<TagObject> tagMap, Sequence<String> tagList, List<ScenarioTag> scenarioList) {
        for (String tag : tagList) {
            List<ScenarioTag> existingTagList;
            boolean exists = false;
            TagObject tagObj = null;
            for (TagObject tagObject : tagMap) {
                if (!tagObject.getTagName().equalsIgnoreCase(tag)) continue;
                exists = true;
                tagObj = tagObject;
                break;
            }
            if (exists) {
                existingTagList = tagObj.getScenarios();
                for (ScenarioTag scenarioTag : scenarioList) {
                    if (!scenarioTag.getScenario().getTagList().contains((Object)tag)) continue;
                    existingTagList = this.addScenarioUnlessExists(existingTagList, scenarioTag);
                }
                tagMap.remove(tagObj);
                tagObj.setScenarios(existingTagList);
                tagMap.add(tagObj);
                continue;
            }
            existingTagList = new ArrayList<ScenarioTag>();
            for (ScenarioTag scenarioTag : scenarioList) {
                if (!scenarioTag.getScenario().getTagList().contains((Object)tag)) continue;
                existingTagList = this.addScenarioUnlessExists(existingTagList, scenarioTag);
            }
            tagObj = new TagObject(tag, existingTagList);
            tagMap.add(tagObj);
        }
        return tagMap;
    }

    public List<TagObject> createOrAppendToTagMapByFeature(List<TagObject> tagMap, Sequence<String> tagList, List<ScenarioTag> scenarioList) {
        for (String tag : tagList) {
            boolean exists = false;
            TagObject tagObj = null;
            for (TagObject tagObject : tagMap) {
                if (!tagObject.getTagName().equalsIgnoreCase(tag)) continue;
                exists = true;
                tagObj = tagObject;
                break;
            }
            if (exists) {
                List<ScenarioTag> existingTagList = tagObj.getScenarios();
                ArrayList<ScenarioTag> all = new ArrayList<ScenarioTag>();
                all.addAll(existingTagList);
                all.addAll(scenarioList);
                tagMap.remove(tagObj);
                tagObj.setScenarios(all);
                tagMap.add(tagObj);
                continue;
            }
            tagObj = new TagObject(tag, scenarioList);
            tagMap.add(tagObj);
        }
        return tagMap;
    }

    public Background getBackgroundInfo() {
        return this.backgroundInfo;
    }
}

