/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.util;

import java.util.List;
import net.masterthought.cucumber.json.support.TagObject;
import org.apache.commons.lang3.StringUtils;

public final class ChartUtil {
    public static String getTags(List<TagObject> tagObjectList) {
        Object[] tagNames = new String[tagObjectList.size()];
        for (int i = 0; i < tagNames.length; ++i) {
            tagNames[i] = StringUtils.wrap((String)tagObjectList.get(i).getTagName(), (String)"'");
        }
        return "[" + StringUtils.join((Object[])tagNames, (String)",") + "]";
    }

    public static String generateTagChartDataForHighCharts(List<TagObject> tagObjectList) {
        StringBuilder buffer = new StringBuilder();
        if (!tagObjectList.isEmpty()) {
            for (TagObject tag : tagObjectList) {
                buffer.append("[");
                buffer.append(tag.getNumberOfPasses());
                buffer.append(",");
                buffer.append(tag.getNumberOfFailures());
                buffer.append(",");
                buffer.append(tag.getNumberOfSkipped());
                buffer.append(",");
                buffer.append(tag.getNumberOfPending());
                buffer.append("]");
                buffer.append(",");
            }
            buffer.setLength(buffer.length() - 1);
        }
        return "[" + buffer.toString() + "]";
    }
}

