/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.ValidationException;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public abstract class AbstractPage {
    private static final Logger LOG = LogManager.getLogger(AbstractPage.class);
    private final VelocityEngine engine = new VelocityEngine();
    protected final VelocityContext context = new VelocityContext();
    private Template template;
    private final String templateFileName;
    protected final ReportResult report;
    protected final Configuration configuration;

    protected AbstractPage(ReportResult reportResult, String templateFileName, Configuration configuration) {
        this.templateFileName = templateFileName;
        this.report = reportResult;
        this.configuration = configuration;
        this.engine.init(this.buildProperties());
        this.buildGeneralParameters();
    }

    public final void generatePage() {
        this.prepareReport();
        this.generateReport();
    }

    public abstract String getWebPage();

    protected abstract void prepareReport();

    private void generateReport() {
        this.context.put("report_file", (Object)this.getWebPage());
        this.template = this.engine.getTemplate("templates/generators/" + this.templateFileName);
        File reportFile = new File(this.configuration.getReportDirectory(), this.getWebPage());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), Charsets.UTF_8);){
            this.template.merge((Context)this.context, (Writer)writer);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    private Properties buildProperties() {
        Properties props = new Properties();
        props.setProperty("resource.loader", "class");
        props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        props.setProperty("runtime.log", new File(this.configuration.getReportDirectory(), "velocity.log").getPath());
        return props;
    }

    private void buildGeneralParameters() {
        this.context.put("jenkins_source", (Object)this.configuration.isRunWithJenkins());
        this.context.put("jenkins_base", (Object)this.configuration.getJenkinsBasePath());
        this.context.put("build_project_name", (Object)this.configuration.getProjectName());
        this.context.put("build_number", (Object)this.configuration.getBuildNumber());
        String formattedTime = this.report != null ? this.report.getBuildTime() : ReportResult.getCurrentTime();
        this.context.put("build_time", (Object)formattedTime);
        String buildNumber = this.configuration.getBuildNumber();
        if (buildNumber != null) {
            if (NumberUtils.isNumber((String)buildNumber)) {
                this.context.put("build_previous_number", (Object)(Integer.parseInt(buildNumber) - 1));
            } else {
                LOG.warn("Could not parse build number: {}.", new Object[]{this.configuration.getBuildNumber()});
            }
        }
    }
}

