/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Iterator;
import net.masterthought.cucumber.json.DocString;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Embedding;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Row;
import net.masterthought.cucumber.json.support.ResultsWithMatch;
import net.masterthought.cucumber.json.support.Status;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class Step
implements ResultsWithMatch {
    private String name = null;
    private final String keyword;
    private final String line;
    private final Result result = null;
    private final Row[] rows = new Row[0];
    private final Match match = null;
    private final Embedding[] embeddings = new Embedding[0];
    private final JsonElement[] output = new JsonElement[0];
    private final DocString doc_string = null;
    private String convertedOutput;
    private Status status;

    public Step() {
        this.keyword = null;
        this.line = null;
    }

    public Row[] getRows() {
        return this.rows;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword.trim();
    }

    public String getOutput() {
        return this.convertedOutput;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    public Embedding[] getEmbeddings() {
        return this.embeddings;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    public boolean hasRows() {
        return ArrayUtils.isNotEmpty((Object[])this.rows);
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public long getDuration() {
        return this.result == null ? 0L : this.result.getDuration();
    }

    public String getErrorMessage() {
        return this.result == null ? null : this.result.getErrorMessage();
    }

    public DocString getDocString() {
        return this.doc_string;
    }

    public void setMedaData(Element element) {
        this.calculateOutputs();
        this.calculateStatus();
    }

    private void calculateOutputs() {
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement element : this.output) {
            if (element.isJsonArray()) {
                Iterator iterator = element.getAsJsonArray().iterator();
                while (iterator.hasNext()) {
                    list.add(Step.elementToString((JsonElement)iterator.next()));
                }
                continue;
            }
            list.add(Step.elementToString(element));
        }
        this.convertedOutput = list.isEmpty() ? null : StringUtils.join(list, (String)"\n");
    }

    private static String elementToString(JsonElement element) {
        if (element.isJsonPrimitive() && !element.getAsJsonPrimitive().isString()) {
            return element.toString();
        }
        return element.getAsString();
    }

    private void calculateStatus() {
        this.status = this.result == null ? Status.MISSING : Status.toStatus(this.result.getStatus());
    }
}

