/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.util;

import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.json.support.TagObject;
import org.apache.commons.lang3.StringUtils;

public final class ChartUtil {
    public static String getTags(List<TagObject> tagObjectList) {
        ArrayList<String> tagNames = new ArrayList<String>();
        for (TagObject tagObject : tagObjectList) {
            tagNames.add(StringUtils.wrap((String)tagObject.getName(), (String)"'"));
        }
        return "[" + StringUtils.join(tagNames, (String)",") + "]";
    }

    public static String generateTagChartDataForHighCharts(List<TagObject> tagObjectList) {
        ArrayList<String> buffers = new ArrayList<String>();
        for (TagObject tag : tagObjectList) {
            buffers.add(String.format("[%d, %d, %d, %d]", tag.getPassedSteps(), tag.getFailedSteps(), tag.getSkippedSteps(), tag.getPendingSteps()));
        }
        return "[" + StringUtils.join(buffers, (String)",") + "]";
    }
}

