/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.Reportable;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.Durationable;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringUtils;

public class Feature
implements Reportable,
Durationable {
    private final String id;
    private final String name;
    @JsonProperty(value="uri")
    private final String uri;
    private final String description;
    private final String keyword;
    private final Integer line = null;
    private Element[] elements = new Element[0];
    private final Tag[] tags = new Tag[0];
    private String reportFileName;
    private String qualifier;
    private final List<Element> scenarios = new ArrayList<Element>();
    private final StatusCounter elementsCounter = new StatusCounter();
    private final StatusCounter stepsCounter = new StatusCounter();
    private Status featureStatus;
    private long duration;

    public Feature() {
        this.id = null;
        this.name = null;
        this.uri = null;
        this.description = null;
        this.keyword = null;
    }

    public String getId() {
        return this.id;
    }

    public String getUri() {
        return this.uri;
    }

    public void addElements(Element[] newElements) {
        Element[] both = Arrays.copyOf(this.elements, this.elements.length + newElements.length);
        System.arraycopy(newElements, 0, both, this.elements.length, newElements.length);
        this.elements = both;
    }

    public Element[] getElements() {
        return this.elements;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    @Override
    public Status getStatus() {
        return this.featureStatus;
    }

    @Override
    public String getName() {
        return StringUtils.defaultString((String)this.name);
    }

    public String getKeyword() {
        return StringUtils.defaultString((String)this.keyword);
    }

    public Integer getLine() {
        return this.line;
    }

    public String getDescription() {
        return StringUtils.defaultString((String)this.description);
    }

    @Override
    public int getFeatures() {
        return 1;
    }

    @Override
    public int getPassedFeatures() {
        return this.getStatus().isPassed() ? 1 : 0;
    }

    @Override
    public int getFailedFeatures() {
        return this.getStatus().isPassed() ? 0 : 1;
    }

    @Override
    public int getScenarios() {
        return this.scenarios.size();
    }

    @Override
    public int getSteps() {
        return this.stepsCounter.size();
    }

    @Override
    public int getPassedSteps() {
        return this.stepsCounter.getValueFor(Status.PASSED);
    }

    @Override
    public int getFailedSteps() {
        return this.stepsCounter.getValueFor(Status.FAILED);
    }

    @Override
    public int getPendingSteps() {
        return this.stepsCounter.getValueFor(Status.PENDING);
    }

    @Override
    public int getSkippedSteps() {
        return this.stepsCounter.getValueFor(Status.SKIPPED);
    }

    @Override
    public int getUndefinedSteps() {
        return this.stepsCounter.getValueFor(Status.UNDEFINED);
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public String getFormattedDuration() {
        return Util.formatDuration(this.duration);
    }

    @Override
    public int getPassedScenarios() {
        return this.elementsCounter.getValueFor(Status.PASSED);
    }

    @Override
    public int getFailedScenarios() {
        return this.elementsCounter.getValueFor(Status.FAILED);
    }

    public void setMetaData(int jsonFileNo, Configuration configuration) {
        for (Element element : this.elements) {
            element.setMetaData(this, configuration);
            if (!element.isScenario()) continue;
            this.scenarios.add(element);
        }
        this.reportFileName = this.calculateReportFileName(jsonFileNo);
        this.featureStatus = this.calculateFeatureStatus();
        this.calculateSteps();
    }

    private String calculateReportFileName(int jsonFileNo) {
        String fileName = "report-feature_";
        if (jsonFileNo > 0) {
            fileName = fileName + jsonFileNo + "_";
        }
        fileName = fileName + Util.toValidFileName(this.uri);
        fileName = fileName + ".html";
        return fileName;
    }

    private Status calculateFeatureStatus() {
        StatusCounter statusCounter = new StatusCounter();
        for (Element element : this.elements) {
            statusCounter.incrementFor(element.getStatus());
        }
        return statusCounter.getFinalStatus();
    }

    private void calculateSteps() {
        for (Element element : this.elements) {
            if (element.isScenario()) {
                this.elementsCounter.incrementFor(element.getStatus());
            }
            for (Step step : element.getSteps()) {
                this.stepsCounter.incrementFor(step.getResult().getStatus());
                this.duration += step.getDuration();
            }
        }
    }
}

