/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.masterthought.cucumber.ReportBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class CucumberReportGeneratorMojo
extends AbstractMojo {
    private String projectName;
    private String buildNumber;
    private File outputDirectory;
    private File cucumberOutput;
    private Boolean skippedFails;
    private Boolean undefinedFails;
    private Boolean pendingFails;
    private Boolean missingFails;
    private Boolean enableFlashCharts;
    private Boolean checkBuildResult;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (File jsonFile : CucumberReportGeneratorMojo.cucumberFiles(this.cucumberOutput)) {
            list.add(jsonFile.getAbsolutePath());
        }
        if (list.isEmpty()) {
            this.getLog().warn((CharSequence)(this.cucumberOutput.getAbsolutePath() + " does not exist."));
            return;
        }
        try {
            boolean buildResult;
            ReportBuilder reportBuilder = new ReportBuilder(list, this.outputDirectory, "", this.buildNumber, this.projectName, this.skippedFails.booleanValue(), this.pendingFails.booleanValue(), this.undefinedFails.booleanValue(), this.missingFails.booleanValue(), this.enableFlashCharts.booleanValue(), false, false, "", false, false);
            this.getLog().info((CharSequence)"About to generate Cucumber report.");
            reportBuilder.generateReports();
            if (this.checkBuildResult.booleanValue() && !(buildResult = reportBuilder.getBuildStatus())) {
                throw new MojoExecutionException("BUILD FAILED - Check Report For Details");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error Found:", e);
        }
    }

    static Collection<File> cucumberFiles(File file) throws MojoExecutionException {
        if (!file.exists()) {
            return Collections.emptyList();
        }
        if (file.isFile()) {
            return Arrays.asList(file);
        }
        return FileUtils.listFiles((File)file, (String[])new String[]{"json"}, (boolean)true);
    }
}

