/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import net.nicholaswilliams.java.licensing.exception.AlgorithmNotSupportedException;
import net.nicholaswilliams.java.licensing.exception.CorruptSignatureException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeyException;
import net.nicholaswilliams.java.licensing.exception.InvalidSignatureException;

public final class DataSignatureManager {
    public final byte[] signData(PrivateKey privateKey, byte[] byArray) throws AlgorithmNotSupportedException, InappropriateKeyException {
        Signature signature = this.getSignature();
        try {
            signature.initSign(privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InappropriateKeyException("While initializing the signature object with the public key.", invalidKeyException);
        }
        try {
            signature.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException("This should never happen.", signatureException);
        }
        try {
            return signature.sign();
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException("This should never happen.", signatureException);
        }
    }

    public final void verifySignature(PublicKey publicKey, byte[] byArray, byte[] byArray2) throws AlgorithmNotSupportedException, InappropriateKeyException, CorruptSignatureException, InvalidSignatureException {
        Signature signature = this.getSignature();
        try {
            signature.initVerify(publicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InappropriateKeyException("While initializing the signature object with the public key.", invalidKeyException);
        }
        try {
            signature.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException("This should never happen.", signatureException);
        }
        try {
            if (!signature.verify(byArray2)) {
                throw new InvalidSignatureException("The license signature is invalid.");
            }
        }
        catch (SignatureException signatureException) {
            throw new CorruptSignatureException("While verifying the signature.", signatureException);
        }
    }

    private final Signature getSignature() {
        try {
            return Signature.getInstance("SHA1withRSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AlgorithmNotSupportedException("SHA-1 with RSA");
        }
    }
}

