/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.LicenseValidator;
import net.nicholaswilliams.java.licensing.exception.ExpiredLicenseException;
import net.nicholaswilliams.java.licensing.exception.InvalidLicenseException;

public class DefaultLicenseValidator
implements LicenseValidator {
    @Override
    public void validateLicense(License license) throws InvalidLicenseException {
        long l = Calendar.getInstance().getTimeInMillis();
        if (license.getGoodAfterDate() > l) {
            throw new InvalidLicenseException("The " + this.getLicenseDescription(license) + " does not take effect until " + this.getFormattedDate(license.getGoodAfterDate()) + ".");
        }
        if (license.getGoodBeforeDate() < l) {
            throw new ExpiredLicenseException("The " + this.getLicenseDescription(license) + " expired on " + this.getFormattedDate(license.getGoodAfterDate()) + ".");
        }
    }

    public String getLicenseDescription(License license) {
        return license.getSubject() + " license for " + license.getHolder();
    }

    public String getFormattedDate(long l) {
        return new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z (Z)").format(new Date(l));
    }
}

