/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.lang.reflect.AnnotatedElement;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Hashtable;
import net.nicholaswilliams.java.licensing.DataSignatureManager;
import net.nicholaswilliams.java.licensing.FeatureObject;
import net.nicholaswilliams.java.licensing.FeatureRestriction;
import net.nicholaswilliams.java.licensing.FeatureRestrictionOperand;
import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.LicenseManagerProperties;
import net.nicholaswilliams.java.licensing.LicenseProvider;
import net.nicholaswilliams.java.licensing.LicenseValidator;
import net.nicholaswilliams.java.licensing.SignedLicense;
import net.nicholaswilliams.java.licensing.encryption.Encryptor;
import net.nicholaswilliams.java.licensing.encryption.KeyFileUtilities;
import net.nicholaswilliams.java.licensing.encryption.PasswordProvider;
import net.nicholaswilliams.java.licensing.encryption.PublicKeyDataProvider;
import net.nicholaswilliams.java.licensing.exception.AlgorithmNotSupportedException;
import net.nicholaswilliams.java.licensing.exception.CorruptSignatureException;
import net.nicholaswilliams.java.licensing.exception.FailedToDecryptException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeyException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeySpecificationException;
import net.nicholaswilliams.java.licensing.exception.InsecureEnvironmentException;
import net.nicholaswilliams.java.licensing.exception.InvalidLicenseException;
import net.nicholaswilliams.java.licensing.exception.InvalidSignatureException;
import net.nicholaswilliams.java.licensing.exception.KeyNotFoundException;

public final class LicenseManager {
    private static LicenseManager instance = null;
    private final PublicKeyDataProvider publicKeyDataProvider;
    private final PasswordProvider publicKeyPasswordProvider;
    private final LicenseProvider licenseProvider;
    private final PasswordProvider licensePasswordProvider;
    private final LicenseValidator licenseValidator;
    private final int cacheTimeInMilliseconds;
    private final Hashtable<Object, LicenseCacheEntry> licenseCache = new Hashtable();

    private LicenseManager() {
        if (LicenseManagerProperties.getLicenseProvider() == null) {
            throw new IllegalArgumentException("Parameter licenseProvider must not be null.");
        }
        if (LicenseManagerProperties.getPublicKeyDataProvider() == null) {
            throw new IllegalArgumentException("Parameter publicKeyDataProvider must not be null.");
        }
        if (LicenseManagerProperties.getPublicKeyPasswordProvider() == null) {
            throw new IllegalArgumentException("Parameter publicKeyPasswordProvider must not be null.");
        }
        try {
            Class.forName("net.nicholaswilliams.java.licensing.LicenseSecurityManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InsecureEnvironmentException("The class net.nicholaswilliams.java.licensing.LicenseSecurityManager could not be initialized.", classNotFoundException);
        }
        int n = LicenseManagerProperties.getCacheTimeInMinutes();
        this.publicKeyDataProvider = LicenseManagerProperties.getPublicKeyDataProvider();
        this.publicKeyPasswordProvider = LicenseManagerProperties.getPublicKeyPasswordProvider();
        this.licenseProvider = LicenseManagerProperties.getLicenseProvider();
        this.licensePasswordProvider = LicenseManagerProperties.getLicensePasswordProvider() == null ? LicenseManagerProperties.getPublicKeyPasswordProvider() : LicenseManagerProperties.getLicensePasswordProvider();
        this.licenseValidator = LicenseManagerProperties.getLicenseValidator();
        this.cacheTimeInMilliseconds = n < 1 ? 10000 : n * 60 * 1000;
    }

    public static synchronized LicenseManager getInstance() {
        if (instance == null) {
            instance = new LicenseManager();
        }
        return instance;
    }

    public final void validateLicense(License license) throws InvalidLicenseException {
        if (this.licenseValidator != null) {
            this.licenseValidator.validateLicense(license);
        }
    }

    public final boolean hasLicenseForFeature(Object object, String string) throws InvalidLicenseException {
        License license = this.getLicense(object);
        if (license == null) {
            return false;
        }
        this.validateLicense(license);
        return license.hasLicenseForFeature(string);
    }

    public final boolean hasLicenseForFeature(Object object, FeatureObject featureObject) throws InvalidLicenseException {
        License license = this.getLicense(object);
        if (license == null) {
            return false;
        }
        this.validateLicense(license);
        return license.hasLicenseForFeature(featureObject);
    }

    public final boolean hasLicenseForAnyFeature(Object object, String ... stringArray) throws InvalidLicenseException {
        License license = this.getLicense(object);
        if (license == null) {
            return false;
        }
        this.validateLicense(license);
        return license.hasLicenseForAnyFeature(stringArray);
    }

    public final boolean hasLicenseForAnyFeature(Object object, FeatureObject ... featureObjectArray) throws InvalidLicenseException {
        License license = this.getLicense(object);
        if (license == null) {
            return false;
        }
        this.validateLicense(license);
        return license.hasLicenseForAnyFeature(featureObjectArray);
    }

    public final boolean hasLicenseForAllFeatures(Object object, String ... stringArray) throws InvalidLicenseException {
        License license = this.getLicense(object);
        if (license == null) {
            return false;
        }
        this.validateLicense(license);
        return license.hasLicenseForAllFeatures(stringArray);
    }

    public final boolean hasLicenseForAllFeatures(Object object, FeatureObject ... featureObjectArray) throws InvalidLicenseException {
        License license = this.getLicense(object);
        if (license == null) {
            return false;
        }
        this.validateLicense(license);
        return license.hasLicenseForAllFeatures(featureObjectArray);
    }

    public final boolean hasLicenseForFeatures(Object object, FeatureRestriction featureRestriction) throws InvalidLicenseException {
        License license = this.getLicense(object);
        if (license == null) {
            return false;
        }
        this.validateLicense(license);
        return featureRestriction.operand() == FeatureRestrictionOperand.AND ? license.hasLicenseForAllFeatures(featureRestriction.value()) : license.hasLicenseForAnyFeature(featureRestriction.value());
    }

    public final boolean hasLicenseForFeatures(Object object, AnnotatedElement annotatedElement) throws InvalidLicenseException {
        License license = this.getLicense(object);
        if (license == null) {
            return false;
        }
        this.validateLicense(license);
        FeatureRestriction featureRestriction = annotatedElement.getAnnotation(FeatureRestriction.class);
        return featureRestriction == null || (featureRestriction.operand() == FeatureRestrictionOperand.AND ? license.hasLicenseForAllFeatures(featureRestriction.value()) : license.hasLicenseForAnyFeature(featureRestriction.value()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final License getLicense(Object object) throws KeyNotFoundException, AlgorithmNotSupportedException, InappropriateKeySpecificationException, InappropriateKeyException, CorruptSignatureException, InvalidSignatureException, FailedToDecryptException {
        LicenseCacheEntry licenseCacheEntry;
        if (object == null) {
            throw new IllegalArgumentException("License context cannot be null.");
        }
        long l = System.currentTimeMillis();
        Hashtable<Object, LicenseCacheEntry> hashtable = this.licenseCache;
        synchronized (hashtable) {
            licenseCacheEntry = this.licenseCache.get(object);
            if (licenseCacheEntry != null && licenseCacheEntry.license != null && licenseCacheEntry.expires <= l) {
                licenseCacheEntry = null;
                this.licenseCache.remove(object);
            }
            if (licenseCacheEntry == null || licenseCacheEntry.license == null) {
                SignedLicense signedLicense = this.licenseProvider.getLicense(object);
                if (signedLicense == null) {
                    return null;
                }
                License license = this.decryptAndVerifyLicense(signedLicense);
                signedLicense.erase();
                long l2 = l + (long)this.cacheTimeInMilliseconds;
                licenseCacheEntry = new LicenseCacheEntry(license, l2);
                this.licenseCache.put(object, licenseCacheEntry);
            }
        }
        return licenseCacheEntry.license;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearLicenseCache() {
        Hashtable<Object, LicenseCacheEntry> hashtable = this.licenseCache;
        synchronized (hashtable) {
            this.licenseCache.clear();
        }
    }

    public final void verifyLicenseSignature(SignedLicense signedLicense) throws AlgorithmNotSupportedException, InappropriateKeyException, CorruptSignatureException, InvalidSignatureException {
        char[] cArray = this.publicKeyPasswordProvider.getPassword();
        byte[] byArray = this.publicKeyDataProvider.getEncryptedPublicKeyData();
        PublicKey publicKey = KeyFileUtilities.readEncryptedPublicKey(byArray, cArray);
        Arrays.fill(cArray, '\u0000');
        Arrays.fill(byArray, (byte)0);
        new DataSignatureManager().verifySignature(publicKey, signedLicense.getLicenseContent(), signedLicense.getSignatureContent());
    }

    public final License decryptAndVerifyLicense(SignedLicense signedLicense) {
        this.verifyLicenseSignature(signedLicense);
        char[] cArray = this.licensePasswordProvider.getPassword();
        byte[] byArray = signedLicense.getLicenseContent();
        byte[] byArray2 = Encryptor.decryptRaw(byArray, cArray);
        Arrays.fill(cArray, '\u0000');
        Arrays.fill(byArray, (byte)0);
        License license = License.deserialize(byArray2);
        Arrays.fill(byArray2, (byte)0);
        return license;
    }

    private static final class LicenseCacheEntry {
        private final License license;
        private final long expires;

        public LicenseCacheEntry(License license, long l) {
            this.license = license;
            this.expires = l;
        }
    }
}

