/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import net.nicholaswilliams.java.licensing.FeatureRestriction;
import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.LicenseManager;
import net.nicholaswilliams.java.licensing.SignedLicense;
import net.nicholaswilliams.java.licensing.exception.InsecureEnvironmentException;

final class LicenseSecurityManager
extends SecurityManager {
    private static LicenseSecurityManager instance;
    private static final String FEATURE_RESTRICTION;
    private static final String SIGNED_LICENSE;
    private static final RuntimePermission CHECK_MEMBER_ACCESS_PERMISSION;
    private static final RuntimePermission SET_SECURITY_MANAGER_PERMISSION;
    private final SecurityManager next;

    protected static boolean securityManagerIsSuitableReplacement(SecurityManager securityManager) {
        if (securityManager == null) {
            throw new IllegalArgumentException("Parameter securityManager cannot be null!");
        }
        try {
            securityManager.checkMemberAccess(License.class, 1);
            return false;
        }
        catch (SecurityException securityException) {
            try {
                securityManager.checkMemberAccess(LicenseManager.class, 1);
                return false;
            }
            catch (SecurityException securityException2) {
                try {
                    securityManager.checkPermission(SET_SECURITY_MANAGER_PERMISSION);
                    return false;
                }
                catch (SecurityException securityException3) {
                    return true;
                }
            }
        }
    }

    private static void installSecurityManagerWithParent(SecurityManager securityManager) {
        try {
            instance = new LicenseSecurityManager(securityManager);
            System.setSecurityManager(instance);
        }
        catch (SecurityException securityException) {
            throw new InsecureEnvironmentException(securityException);
        }
    }

    private LicenseSecurityManager(SecurityManager securityManager) {
        this.next = securityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMemberAccess(Class<?> clazz, int n) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter reflectionClass cannot be null.");
        }
        this.inCheck = true;
        try {
            if (n != 0) {
                Class<?>[] classArray;
                Package package_ = clazz.getPackage();
                if (package_ != null && package_.getName().startsWith("net.nicholaswilliams.java.licensing") && !clazz.getCanonicalName().equals(FEATURE_RESTRICTION) && !clazz.getCanonicalName().equals(SIGNED_LICENSE)) {
                    throw new SecurityException("Reflection access to non-public members of LicenseManager class [" + clazz.getSimpleName() + "] prohibited.");
                }
                if (!(clazz != Class.class && clazz != System.class || (classArray = this.getClassContext()).length >= 4 && classArray[3].getPackage().getName().startsWith("java."))) {
                    throw new SecurityException("Reflection access to non-public members of java.lang.Class and java.lang.System prohibited.");
                }
                if (this.next != null && ((classArray = this.getClassContext()).length < 4 || classArray[3].getClassLoader() != clazz.getClassLoader())) {
                    this.checkPermission(CHECK_MEMBER_ACCESS_PERMISSION);
                }
            }
        }
        finally {
            this.inCheck = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPermission(Permission permission) {
        this.inCheck = true;
        try {
            if (permission.getName().equals("setSecurityManager")) {
                throw new SecurityException("Setting a SecurityManager other than the LicenseSecurityManager is prohibited.");
            }
            if (this.next != null) {
                this.next.checkPermission(permission);
            }
        }
        finally {
            this.inCheck = false;
        }
    }

    @Override
    public void checkPackageAccess(String string) {
        if (this.next != null) {
            this.next.checkPackageAccess(string);
        }
    }

    @Override
    public void checkPermission(Permission permission, Object object) {
        if (this.next != null) {
            this.next.checkPermission(permission, object);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (this.next != null) {
            this.next.checkCreateClassLoader();
        }
    }

    @Override
    public void checkAccess(Thread thread) {
        if (this.next != null) {
            this.next.checkAccess(thread);
        }
    }

    @Override
    public void checkAccess(ThreadGroup threadGroup) {
        if (this.next != null) {
            this.next.checkAccess(threadGroup);
        }
    }

    @Override
    public void checkExit(int n) {
        if (this.next != null) {
            this.next.checkExit(n);
        }
    }

    @Override
    public void checkExec(String string) {
        if (this.next != null) {
            this.next.checkExec(string);
        }
    }

    @Override
    public void checkLink(String string) {
        if (this.next != null) {
            this.next.checkLink(string);
        }
    }

    @Override
    public void checkRead(FileDescriptor fileDescriptor) {
        if (this.next != null) {
            this.next.checkRead(fileDescriptor);
        }
    }

    @Override
    public void checkRead(String string) {
        if (this.next != null) {
            this.next.checkRead(string);
        }
    }

    @Override
    public void checkRead(String string, Object object) {
        if (this.next != null) {
            this.next.checkRead(string);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fileDescriptor) {
        if (this.next != null) {
            this.next.checkWrite(fileDescriptor);
        }
    }

    @Override
    public void checkWrite(String string) {
        if (this.next != null) {
            this.next.checkWrite(string);
        }
    }

    @Override
    public void checkDelete(String string) {
        if (this.next != null) {
            this.next.checkDelete(string);
        }
    }

    @Override
    public void checkConnect(String string, int n) {
        if (this.next != null) {
            this.next.checkConnect(string, n);
        }
    }

    @Override
    public void checkConnect(String string, int n, Object object) {
        if (this.next != null) {
            this.next.checkConnect(string, n, object);
        }
    }

    @Override
    public void checkListen(int n) {
        if (this.next != null) {
            this.next.checkListen(n);
        }
    }

    @Override
    public void checkAccept(String string, int n) {
        if (this.next != null) {
            this.next.checkAccept(string, n);
        }
    }

    @Override
    public void checkMulticast(InetAddress inetAddress) {
        if (this.next != null) {
            this.next.checkMulticast(inetAddress);
        }
    }

    @Override
    public void checkMulticast(InetAddress inetAddress, byte by) {
        if (this.next != null) {
            this.next.checkMulticast(inetAddress, by);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.next != null) {
            this.next.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String string) {
        if (this.next != null) {
            this.next.checkPropertyAccess(string);
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.next != null) {
            this.next.checkPrintJobAccess();
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.next != null) {
            this.next.checkSystemClipboardAccess();
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.next != null) {
            this.next.checkAwtEventQueueAccess();
        }
    }

    @Override
    public void checkPackageDefinition(String string) {
        if (this.next != null) {
            this.next.checkPackageDefinition(string);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.next != null) {
            this.next.checkSetFactory();
        }
    }

    @Override
    public void checkSecurityAccess(String string) {
        if (this.next != null) {
            this.next.checkSecurityAccess(string);
        }
    }

    public boolean checkTopLevelWindow(Object object) {
        return this.next == null || this.next.checkTopLevelWindow(object);
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.next != null ? this.next.getThreadGroup() : super.getThreadGroup();
    }

    @Override
    public Object getSecurityContext() {
        return this.next != null ? this.next.getSecurityContext() : super.getSecurityContext();
    }

    protected static LicenseSecurityManager getInstance() {
        return instance;
    }

    static {
        FEATURE_RESTRICTION = FeatureRestriction.class.getCanonicalName();
        SIGNED_LICENSE = SignedLicense.class.getCanonicalName();
        CHECK_MEMBER_ACCESS_PERMISSION = new RuntimePermission("accessDeclaredMembers");
        SET_SECURITY_MANAGER_PERMISSION = new RuntimePermission("setSecurityManager");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            LicenseSecurityManager.installSecurityManagerWithParent(null);
        } else if (!securityManager.getClass().equals(LicenseSecurityManager.class) && !LicenseSecurityManager.securityManagerIsSuitableReplacement(securityManager)) {
            LicenseSecurityManager.installSecurityManagerWithParent(securityManager);
        }
    }
}

