/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import net.nicholaswilliams.java.licensing.exception.ObjectDeserializationException;
import net.nicholaswilliams.java.licensing.exception.ObjectSerializationException;
import net.nicholaswilliams.java.licensing.exception.ObjectTypeNotExpectedException;
import org.apache.commons.io.output.ByteArrayOutputStream;

public final class ObjectSerializer {
    public final <T extends Serializable> T readObject(Class<T> clazz, byte[] byArray) throws ObjectDeserializationException {
        Serializable serializable;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            if (!clazz.isInstance(object)) {
                throw new ObjectTypeNotExpectedException(clazz.getName(), object.getClass().getName());
            }
            serializable = (Serializable)clazz.cast(object);
        }
        catch (IOException iOException) {
            throw new ObjectDeserializationException("An I/O error occurred while reading the object from the byte array.", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ObjectTypeNotExpectedException(clazz.getName(), classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ObjectTypeNotExpectedException(clazz.getName(), noClassDefFoundError.getMessage(), noClassDefFoundError);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (T)serializable;
    }

    public final byte[] writeObject(Serializable serializable) throws ObjectSerializationException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
        }
        catch (IOException iOException) {
            throw new ObjectSerializationException(iOException);
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return byteArrayOutputStream.toByteArray();
    }
}

