/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.encryption;

import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.nicholaswilliams.java.licensing.encryption.Encryptor;
import net.nicholaswilliams.java.licensing.exception.AlgorithmNotSupportedException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeySpecificationException;
import org.apache.commons.io.FileUtils;

public class KeyFileUtilities {
    public static final String keyAlgorithm = "RSA";

    protected static void writeEncryptedPrivateKey(PrivateKey privateKey, File file, char[] cArray) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])KeyFileUtilities.writeEncryptedPrivateKey(privateKey, cArray));
    }

    protected static void writeEncryptedPublicKey(PublicKey publicKey, File file, char[] cArray) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])KeyFileUtilities.writeEncryptedPublicKey(publicKey, cArray));
    }

    protected static PrivateKey readEncryptedPrivateKey(File file, char[] cArray) throws IOException {
        return KeyFileUtilities.readEncryptedPrivateKey(FileUtils.readFileToByteArray((File)file), cArray);
    }

    protected static PublicKey readEncryptedPublicKey(File file, char[] cArray) throws IOException {
        return KeyFileUtilities.readEncryptedPublicKey(FileUtils.readFileToByteArray((File)file), cArray);
    }

    protected static byte[] writeEncryptedPrivateKey(PrivateKey privateKey, char[] cArray) {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        return Encryptor.encryptRaw(pKCS8EncodedKeySpec.getEncoded(), cArray);
    }

    protected static byte[] writeEncryptedPublicKey(PublicKey publicKey, char[] cArray) {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        return Encryptor.encryptRaw(x509EncodedKeySpec.getEncoded(), cArray);
    }

    public static PrivateKey readEncryptedPrivateKey(byte[] byArray, char[] cArray) {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(Encryptor.decryptRaw(byArray, cArray));
        try {
            return KeyFactory.getInstance(keyAlgorithm).generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AlgorithmNotSupportedException(keyAlgorithm, noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InappropriateKeySpecificationException(invalidKeySpecException);
        }
    }

    public static PublicKey readEncryptedPublicKey(byte[] byArray, char[] cArray) {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Encryptor.decryptRaw(byArray, cArray));
        try {
            return KeyFactory.getInstance(keyAlgorithm).generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AlgorithmNotSupportedException(keyAlgorithm, noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InappropriateKeySpecificationException(invalidKeySpecException);
        }
    }

    private KeyFileUtilities() {
        throw new RuntimeException("This class cannot be instantiated.");
    }
}

