/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.immutable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.nicholaswilliams.java.licensing.immutable.ImmutableAbstractCollection;
import net.nicholaswilliams.java.licensing.immutable.ImmutableListIterator;

public final class ImmutableArrayList<E>
extends ImmutableAbstractCollection<E>
implements List<E>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -6912407141647481417L;
    private final ArrayList<E> internalList;

    public ImmutableArrayList(List<E> list) {
        super(new ArrayList<E>(list));
        this.internalList = (ArrayList)this.internalCollection;
        this.internalList.trimToSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ImmutableArrayList<E> clone() {
        ArrayList<E> arrayList = this.internalList;
        synchronized (arrayList) {
            this.checkValidity();
            return new ImmutableArrayList<E>((List)this.internalList.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E get(int n) {
        ArrayList<E> arrayList = this.internalList;
        synchronized (arrayList) {
            this.checkValidity();
            return this.internalList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int indexOf(Object object) {
        ArrayList<E> arrayList = this.internalList;
        synchronized (arrayList) {
            this.checkValidity();
            return this.internalList.indexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int lastIndexOf(Object object) {
        ArrayList<E> arrayList = this.internalList;
        synchronized (arrayList) {
            this.checkValidity();
            return this.internalList.lastIndexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ImmutableListIterator<E> listIterator() {
        ArrayList<E> arrayList = this.internalList;
        synchronized (arrayList) {
            this.checkValidity();
            return new ImmutableListIterator<E>(this.internalList.listIterator(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ImmutableListIterator<E> listIterator(int n) {
        ArrayList<E> arrayList = this.internalList;
        synchronized (arrayList) {
            this.checkValidity();
            return new ImmutableListIterator<E>(this.internalList.listIterator(n), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ImmutableArrayList<E> subList(int n, int n2) {
        ArrayList<E> arrayList = this.internalList;
        synchronized (arrayList) {
            this.checkValidity();
            List<E> list = this.internalList.subList(n, n2);
            return new ImmutableArrayList<E>(list);
        }
    }

    @Override
    public final void add(int n, E e) {
        throw new UnsupportedOperationException("This list cannot be modified.");
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("This list cannot be modified.");
    }

    @Override
    public final E remove(int n) {
        throw new UnsupportedOperationException("This list cannot be modified.");
    }

    @Override
    public final E set(int n, E e) {
        throw new UnsupportedOperationException("This list cannot be modified.");
    }
}

