/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk;

import java.util.Date;
import net.objectlab.kit.datecalc.common.AbstractKitCalculatorsFactory;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.IMMDateCalculator;
import net.objectlab.kit.datecalc.common.PeriodCountCalculator;
import net.objectlab.kit.datecalc.jdk.DateBackwardHandler;
import net.objectlab.kit.datecalc.jdk.DateDateCalculator;
import net.objectlab.kit.datecalc.jdk.DateForwardHandler;
import net.objectlab.kit.datecalc.jdk.DateForwardUnlessNegativeHandler;
import net.objectlab.kit.datecalc.jdk.DateIMMDateCalculator;
import net.objectlab.kit.datecalc.jdk.DateModifiedFollowingHandler;
import net.objectlab.kit.datecalc.jdk.DateModifiedPrecedingHandler;
import net.objectlab.kit.datecalc.jdk.DatePeriodCountCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateKitCalculatorsFactory
extends AbstractKitCalculatorsFactory<Date> {
    private static final DateKitCalculatorsFactory DEFAULT = new DateKitCalculatorsFactory();
    private static final PeriodCountCalculator<Date> PCC = new DatePeriodCountCalculator();
    private static final DateIMMDateCalculator IMMDC = new DateIMMDateCalculator();

    public static DateKitCalculatorsFactory getDefaultInstance() {
        return DEFAULT;
    }

    @Override
    public DateCalculator<Date> getDateCalculator(String name, String holidayHandlerType) {
        DateDateCalculator cal = new DateDateCalculator();
        cal.setName(name);
        this.setHolidays(name, cal);
        if (holidayHandlerType == null) {
            return cal;
        }
        if ("forward".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new DateForwardHandler());
        } else if ("backward".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new DateBackwardHandler());
        } else if ("modifiedFollowing".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new DateModifiedFollowingHandler());
        } else if ("modifiedPreceding".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new DateModifiedPrecedingHandler());
        } else if ("forwardUnlessMovingBack".equals(holidayHandlerType)) {
            cal.setHolidayHandler(new DateForwardUnlessNegativeHandler());
        } else {
            throw new IllegalArgumentException("Unsupported HolidayHandler: " + holidayHandlerType);
        }
        return cal;
    }

    @Override
    public PeriodCountCalculator<Date> getPeriodCountCalculator() {
        return PCC;
    }

    @Override
    public IMMDateCalculator<Date> getIMMDateCalculator() {
        return IMMDC;
    }
}

