/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import net.objectlab.kit.datecalc.common.BaseCalculator;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.NonWorkingDayChecker;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDateModifiedFollowingHandler
implements HolidayHandler<LocalDate> {
    public LocalDate moveCurrentDate(BaseCalculator<LocalDate> calculator) {
        return this.adjustDate((LocalDate)calculator.getCurrentBusinessDate(), 1, (NonWorkingDayChecker<LocalDate>)calculator);
    }

    public LocalDate adjustDate(LocalDate startDate, int increment, NonWorkingDayChecker<LocalDate> checker) {
        LocalDate date = startDate;
        int month = date.getMonthOfYear();
        int stepToUse = increment;
        while (checker.isNonWorkingDay((Object)date)) {
            if ((date = date.plusDays(stepToUse)).getMonthOfYear() == month) continue;
            date = date.plusDays(stepToUse *= -1);
        }
        return date;
    }

    public String getType() {
        return "modifiedFollowing";
    }
}

