/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.m2.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import net.objectlab.qalab.m2.report.MainReport;
import net.objectlab.qalab.m2.util.Utils;
import net.objectlab.qalab.m2.util.XmlTransformer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;

public class MoversReport
extends AbstractMavenReport {
    private File inputMoversFile = null;
    private InputStream theXmlStream = null;
    private File moversStyleSheet = null;
    private InputStream theStyleSheetStream = null;
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected final void executeReport(Locale aLocale) throws MavenReportException {
        File output;
        this.validate();
        File outdir = new File(this.getOutputDirectory());
        if (!outdir.exists()) {
            outdir.mkdirs();
        }
        if (!$assertionsDisabled && !outdir.isDirectory()) {
            throw new AssertionError((Object)"the output directory was not a directory");
        }
        try {
            output = new File(outdir, "movers.html");
            output.createNewFile();
        }
        catch (IOException ioex) {
            throw new MavenReportException("could not create output file.", (Exception)ioex);
        }
        XmlTransformer t = new XmlTransformer(this.theXmlStream, this.theStyleSheetStream, output);
        try {
            t.transform();
        }
        catch (TransformerException tex) {
            throw new MavenReportException("transformation failed.", (Exception)tex);
        }
    }

    public final String getOutputName() {
        return "qalab/movers";
    }

    protected final String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected final MavenProject getProject() {
        return this.project;
    }

    protected final SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public final String getName(Locale aLocale) {
        return MoversReport.getBundle(aLocale).getString("report.qalab.movers.name");
    }

    public final String getDescription(Locale aLocale) {
        return MoversReport.getBundle(aLocale).getString("report.qalab.movers.description");
    }

    public final boolean isExternalReport() {
        return true;
    }

    private static ResourceBundle getBundle(Locale aLocale) {
        return ResourceBundle.getBundle("qalab-report", aLocale, MainReport.class.getClassLoader());
    }

    private void validate() throws MavenReportException {
        try {
            Utils.checkFile(this.inputMoversFile, "inputMoversFile");
            this.theXmlStream = new FileInputStream(this.inputMoversFile);
        }
        catch (IOException ioex) {
            throw new MavenReportException(ioex.getMessage(), (Exception)ioex);
        }
        if (this.moversStyleSheet == null) {
            try {
                this.theStyleSheetStream = Utils.extractAsInputStream("qalab-movers-html.xsl");
            }
            catch (IOException ioex) {
                throw new MavenReportException("Could not find the default stylesheet. " + ioex.getMessage(), (Exception)ioex);
            }
        }
        try {
            Utils.checkFile(this.moversStyleSheet, "moversStyleSheet");
            this.theStyleSheetStream = new FileInputStream(this.moversStyleSheet);
        }
        catch (IOException ioex) {
            throw new MavenReportException(ioex.getMessage(), (Exception)ioex);
        }
    }

    static {
        $assertionsDisabled = !MoversReport.class.desiredAssertionStatus();
    }
}

