/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.m2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.objectlab.qalab.m2.util.Maven2TaskLogger;
import net.objectlab.qalab.m2.util.Utils;
import net.objectlab.qalab.parser.BuildStatForChartParser;
import net.objectlab.qalab.util.TaskLogger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class BuildStatChartMojo
extends AbstractMojo {
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static final int DEFAULT_WIDTH = 950;
    private static final int DEFAULT_HEIGHT = 600;
    private File qalabFile = null;
    private File toDir = null;
    private boolean quiet = false;
    private int width = 950;
    private int height = 600;
    private int movingAverage = 0;
    private boolean summaryOnly = true;
    private String types = "checkstyle";

    public final void execute() throws MojoExecutionException {
        this.validate();
        if (!this.quiet) {
            this.getLog().debug((CharSequence)("qalabFile='" + this.qalabFile.getPath() + "', toDir='" + this.toDir.getPath() + "' width='" + this.width + "' height='" + this.height + "' summaryOnly='" + this.summaryOnly + "'"));
        }
        this.generateCharts();
    }

    private void generateCharts() throws MojoExecutionException {
        BuildStatForChartParser myForChartParser = new BuildStatForChartParser((TaskLogger)new Maven2TaskLogger((Mojo)this));
        myForChartParser.setChartHeight(this.height);
        myForChartParser.setChartWidth(this.width);
        myForChartParser.setToDir(this.toDir.getAbsolutePath() + "/");
        myForChartParser.setMovingAverage(this.movingAverage);
        myForChartParser.setSummaryOnly(this.summaryOnly);
        myForChartParser.setAcceptedStyle(this.types);
        myForChartParser.setQuiet(this.quiet);
        XMLReader parser = null;
        try {
            parser = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
            parser.setContentHandler((ContentHandler)myForChartParser);
            parser.setErrorHandler((ErrorHandler)myForChartParser);
            if (!this.quiet) {
                this.getLog().debug((CharSequence)("Parsing " + this.qalabFile));
            }
            parser.parse(new InputSource(new FileInputStream(this.qalabFile)));
        }
        catch (SAXException sex) {
            this.getLog().error((CharSequence)sex.toString());
            throw new MojoExecutionException("Error generating charts.", (Exception)sex);
        }
        catch (FileNotFoundException fnfex) {
            this.getLog().error((CharSequence)fnfex.toString());
            throw new MojoExecutionException("Error generating charts.", (Exception)fnfex);
        }
        catch (IOException ioex) {
            this.getLog().error((CharSequence)ioex.toString());
            throw new MojoExecutionException("Error generating charts.", (Exception)ioex);
        }
    }

    private void validate() throws MojoExecutionException {
        try {
            Utils.checkFile(this.qalabFile, "qalabFile");
        }
        catch (IOException ioex) {
            throw new MojoExecutionException(ioex.getMessage(), (Exception)ioex);
        }
        if (this.toDir == null) {
            throw new MojoExecutionException("toDir is mandatory");
        }
        if (this.toDir.exists() && !this.toDir.isDirectory()) {
            String message = "toDir must be a directory (" + this.toDir + ")";
            throw new MojoExecutionException(message);
        }
        if (!this.toDir.exists()) {
            if (!this.quiet) {
                this.getLog().debug((CharSequence)("Creating directory: " + this.toDir.toString()));
            }
            this.toDir.mkdir();
        }
    }
}

