/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.m2;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import net.objectlab.qalab.m2.util.Maven2TaskLogger;
import net.objectlab.qalab.m2.util.Utils;
import net.objectlab.qalab.parser.BuildStatMoverHandler;
import net.objectlab.qalab.util.QALabTags;
import net.objectlab.qalab.util.TaskLogger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BuildStatMoversMojo
extends AbstractMojo {
    private static final int MIN_DATE_SIZE = 18;
    private File qalabFile = null;
    private String startTimeHoursOffset = null;
    private String types = "checkstyle";
    private File outputXMLfile;
    private boolean quiet = false;
    private boolean weekendAdjustment = true;
    private String startTimeWindow = null;
    private String endTimeWindow = null;

    public final void execute() throws MojoExecutionException {
        this.validate();
        if (!this.quiet) {
            this.getLog().debug((CharSequence)("qalabFile='" + this.qalabFile.getPath() + "', type='" + this.types + "'" + " output='" + this.outputXMLfile.getPath() + "' adjustForWeekend='" + this.weekendAdjustment + "'" + " startTimeOffset='" + this.startTimeHoursOffset + "'" + " startTimeWindow='" + this.startTimeWindow + "'" + " endTimeWindow='" + this.endTimeWindow + "'"));
        }
        try {
            Maven2TaskLogger logger = new Maven2TaskLogger((Mojo)this);
            BuildStatMoverHandler handler = new BuildStatMoverHandler(new InputSource(new FileReader(this.qalabFile)), this.types, (Writer)new FileWriter(this.outputXMLfile), this.weekendAdjustment, (TaskLogger)logger, this.quiet);
            if (this.startTimeWindow != null) {
                handler.setStartTimeWindow(QALabTags.DEFAULT_DATETIME_FORMAT.parse(this.fixTime(this.startTimeWindow)));
            }
            if (this.endTimeWindow != null) {
                handler.setEndTimeWindow(QALabTags.DEFAULT_DATETIME_FORMAT.parse(this.fixTime(this.endTimeWindow)));
            }
            if (this.startTimeHoursOffset != null) {
                handler.setOffsetHours(this.startTimeHoursOffset);
            }
            handler.process();
        }
        catch (ParserConfigurationException pcex) {
            this.getLog().error((CharSequence)pcex.toString());
        }
        catch (SAXException sex) {
            this.getLog().error((CharSequence)sex.toString());
        }
        catch (IOException ioex) {
            this.getLog().error((CharSequence)ioex.toString());
        }
        catch (ParseException pex) {
            throw new MojoExecutionException("Date Parse issue", (Exception)pex);
        }
    }

    private void validate() throws MojoExecutionException {
        try {
            Utils.checkFile(this.qalabFile, "qalabFile");
        }
        catch (IOException ioex) {
            throw new MojoExecutionException(ioex.getMessage(), (Exception)ioex);
        }
        if (this.startTimeHoursOffset == null && this.startTimeWindow == null) {
            throw new MojoExecutionException("Please set startTimeHoursOffset or startTimeWindow.");
        }
        if (this.startTimeHoursOffset != null && this.startTimeWindow != null) {
            throw new MojoExecutionException("Use startTimeHoursOffset OR startTimeWindow, not both.");
        }
        File dir = this.outputXMLfile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private String fixTime(String aTime) {
        String result = aTime.trim();
        if (result.length() < 18) {
            result = result + " 00:00:00";
        }
        return result;
    }
}

