////////////////////////////////////////////////////////////////////////////////
//
//                  ObjectLab is sponsoring QALab
//
// Based in London, we are world leaders in the design and development
// of bespoke applications for the Securities Financing markets.
//
// <a href="http://www.objectlab.co.uk/open">Click here to learn more</a>
//           ___  _     _           _   _          _
//          / _ \| |__ (_) ___  ___| |_| |    __ _| |__
//         | | | | '_ \| |/ _ \/ __| __| |   / _` | '_ \
//         | |_| | |_) | |  __/ (__| |_| |__| (_| | |_) |
//          \___/|_.__// |\___|\___|\__|_____\__,_|_.__/
//                   |__/
//
//                   http://www.ObjectLab.co.uk
// ---------------------------------------------------------------------------
//
//QALab is released under the GNU General Public License.
//
//QALab: Collects QA Statistics from your build over time.
//2005+, ObjectLab Ltd
//
//This library is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public
//License as published by the Free Software Foundation; either
//version 2.1 of the License, or (at your option) any later version.
//
//This library is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//General Public License for more details.
//
//You should have received a copy of the GNU General Public
//License along with this library; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
////////////////////////////////////////////////////////////////////////////////
package net.objectlab.qalab.m2;

/**
 * Goal which generates the QALab BuildStat chart.
 * 
 * @author Benoit Xhenseval
 * @goal cobertura-chart
 * @phase site
 */
public class CoberturaChartMojo extends BuildStatChartMojo {
    /**
     * If true then generate a summary chart only.
     * 
     * @parameter default-value=true
     */
    private boolean summaryOnly = true;

    /**
     * Statistic type to appear on summary chart, defaulted to
     * 'cobertura-branch,cobertura-line'.
     * 
     * @parameter default-value="cobertura-branch,cobertura-line"
     */
    private String summaryTypes = "cobertura-branch,cobertura-line";

    /**
     * File prefix for the charts (e.g. cobertura-) Default empty.
     * 
     * @parameter default-value="cobertura-"
     */
    private String filePrefix = null;

    /**
     * @return the filePrefix
     */
    public String getFilePrefix() {
        return filePrefix;
    }

    /**
     * @param filePrefix the filePrefix to set
     */
    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    /**
     * @return the summaryOnly
     */
    public boolean isSummaryOnly() {
        return summaryOnly;
    }

    /**
     * @param summaryOnly the summaryOnly to set
     */
    public void setSummaryOnly(boolean summaryOnly) {
        this.summaryOnly = summaryOnly;
    }

    /**
     * @return the summaryTypes
     */
    public String getSummaryTypes() {
        return summaryTypes;
    }

    /**
     * @param summaryTypes the summaryTypes to set
     */
    public void setSummaryTypes(String summaryTypes) {
        this.summaryTypes = summaryTypes;
    }
}
/*
 *                   ObjectLab is sponsoring QALab
 * 
 * Based in London, we are world leaders in the design and development 
 * of bespoke applications for the securities financing markets.
 * 
 * <a href="http://www.objectlab.co.uk/open">Click here to learn more about us</a>
 *           ___  _     _           _   _          _
 *          / _ \| |__ (_) ___  ___| |_| |    __ _| |__
 *         | | | | '_ \| |/ _ \/ __| __| |   / _` | '_ \
 *         | |_| | |_) | |  __/ (__| |_| |__| (_| | |_) |
 *          \___/|_.__// |\___|\___|\__|_____\__,_|_.__/
 *                   |__/
 *
 *                     www.ObjectLab.co.uk
 */
