////////////////////////////////////////////////////////////////////////////////
//
//                  ObjectLab is sponsoring QALab
//
// Based in London, we are world leaders in the design and development
// of bespoke applications for the Securities Financing markets.
//
// <a href="http://www.objectlab.co.uk/open">Click here to learn more</a>
//           ___  _     _           _   _          _
//          / _ \| |__ (_) ___  ___| |_| |    __ _| |__
//         | | | | '_ \| |/ _ \/ __| __| |   / _` | '_ \
//         | |_| | |_) | |  __/ (__| |_| |__| (_| | |_) |
//          \___/|_.__// |\___|\___|\__|_____\__,_|_.__/
//                   |__/
//
//                   http://www.ObjectLab.co.uk
// ---------------------------------------------------------------------------
//
//QALab is released under the GNU General Public License.
//
//QALab: Collects QA Statistics from your build over time.
//2005+, ObjectLab Ltd
//
//This library is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public
//License as published by the Free Software Foundation; either
//version 2.1 of the License, or (at your option) any later version.
//
//This library is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//General Public License for more details.
//
//You should have received a copy of the GNU General Public
//License along with this library; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
////////////////////////////////////////////////////////////////////////////////
package net.objectlab.qalab.m2.report;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.io.FileInputStream;
import java.io.InputStream;

import net.objectlab.qalab.m2.BuildStatMoversMojo;
import net.objectlab.qalab.m2.util.Utils;
import net.objectlab.qalab.m2.util.XmlTransformer;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

import org.codehaus.doxia.site.renderer.SiteRenderer;
import javax.xml.transform.TransformerException;

/**
 * *** IMPORTANT: USE this Report AFTER the merge and chart report, it will calculate the 
 * movers and generate of the Movers report.
 * 
 * @author Benoit Xhenseval.
 * @goal report-movers-all
 * @phase deploy
 */
public class MoversReport extends AbstractMavenReport {
    // ~ Movers COMPUTATION -------------------------------------------------------
    /**
     * The qalabFile, typically qalab.xml.
     * 
     * @parameter expression="${project.basedir}/qalab.xml"
     */
    private File qalabFile = null;

    /**
     * The number of hours to define the time window from now.
     * 
     * @parameter default-value="54"
     */
    private String startTimeHoursOffset = null;

    /**
     * Statistic types to be taken into account
     * (checkstyle|findbugs|pmd|simian|pmd-cpd|cobertura-line|cobertura-branch).
     * Or comma separated combinations. Default is checkstyle, pmd and findbugs. Please note
     * that there is no point of adding pmd-cpd or simian  as no statistics are
     * kept at file level for those.
     * 
     * @parameter default-value="checkstyle,pmd,findbugs,cobertura-line,cobertura-branch"
     */
    private String types = "checkstyle,pmd,findbugs,cobertura-line,cobertura-branch";

    /**
     * The output XML file with ups and downs.
     * 
     * @parameter expression="${project.build.directory}/qalab/qalab-movers.xml"
     */
    private File qalabMoversOutputFile;

    /**
     * If true then any debug logging output will be suppressed.
     * 
     * @parameter default-value=false
     */
    private boolean quiet = false;

    /**
     * if true, adjust for weekend ie add 48h if start time falls on a weekend.
     * 
     * @parameter default-value=true
     */
    private boolean weekendAdjustment = true;

    /**
     * Start Time Window (instead of using startTimeHoursOffset). parameter
     */
    private String startTimeWindow = null;

    /**
     * End Time Window (instead of assuming "now"). parameter
     */
    private String endTimeWindow = null;

    // ~ Instance fields -------------------------------------------------------

    /**
     * The report file name.
     * 
     * @parameter expression="movers.xml"
     * @required
     */
    private String outputFileName;

    /**
     * The directory where the generated html report will go. @ parameter
     * expression="${project.reporting.outputDirectory}/qalab"
     * @parameter expression="${project.build.directory}/generated-site/xdoc"
     * @required
     */
    private String outputDirectory;

    /**
     * The xslt stylesheet bundled, either qalab-movers-xdoc.xsl or
     * qalab-movers-html.xsl.
     * 
     * @parameter default-value="qalab-movers-xdoc.xsl";
     */
    private String moversBundledXsl = null;

    /**
     * Not sure what this is.
     * 
     * @component
     */
    private SiteRenderer siteRenderer;

    /**
     * The maven project.
     * 
     * @parameter expression="${project}"
     * @required
     * @readonly
     */
    private MavenProject project;

    /**
     * The xml input stream.
     */
    private InputStream theXmlStream = null;

    /**
     * The xslt style sheet.
     * 
     * @parameter
     */
    private File moversStyleSheet = null;

    /**
     * The xslt style sheet input stream.
     */
    private InputStream theStyleSheetStream = null;

    /**
     * generate the actual report.
     * 
     * @param aLocale
     *            ignored.
     * @throws MavenReportException
     *             if anything goes wrong.
     */
    protected final void executeReport(final Locale aLocale) throws MavenReportException {
        getLog().info("----------------------------------------");
        getLog().info("QALab Movers Computation and Report");
        try {
            doCalculateMovers();
        } catch (MojoExecutionException e) {
            throw new MavenReportException("Issue creating the movers file", e);
        }

        validate();

        final File outdir = new File(getOutputDirectory());
        if (!outdir.exists()) {
            outdir.mkdirs();
        }
        assert outdir.isDirectory() : "the output directory was not a directory";

        final File output;
        try {
            output = new File(outdir, outputFileName);
            output.createNewFile();
        } catch (IOException ioex) {
            throw new MavenReportException("could not create output file.", ioex);
        }

        final XmlTransformer t = new XmlTransformer(theXmlStream, theStyleSheetStream, output);
        try {
            t.transform();
        } catch (TransformerException tex) {
            throw new MavenReportException("transformation failed.", tex);
        }

    }

    private void doCalculateMovers() throws MojoExecutionException {
        BuildStatMoversMojo mojo = new BuildStatMoversMojo();
        mojo.setEndTimeWindow(endTimeWindow);
        mojo.setQalabFile(qalabFile);
        mojo.setQalabMoversOutputFile(qalabMoversOutputFile);
        mojo.setQuiet(quiet);
        mojo.setStartTimeHoursOffset(startTimeHoursOffset);
        mojo.setStartTimeWindow(startTimeWindow);
        mojo.setTypes(types);
        mojo.setWeekendAdjustment(weekendAdjustment);
        mojo.setPluginContext(getPluginContext());
        
        mojo.execute();
    }

    /**
     * @return "outputFileName up to the first '.'"
     * @see org.apache.maven.reporting.MavenReport#getOutputName()
     */
    public final String getOutputName() {
        // return "movers";
        return outputFileName.substring(0, outputFileName.indexOf('.'));
    }

    /**
     * @return The output directory as configured in your <code>pom.xml</code>.
     * @see org.apache.maven.reporting.AbstractMavenReport#getOutputDirectory()
     */
    protected final String getOutputDirectory() {
        return outputDirectory;
    }

    /**
     * @return The Maven Project itself. Used internally to get access to Config
     *         params etc.
     * @see org.apache.maven.reporting.AbstractMavenReport#getProject()
     */
    protected final MavenProject getProject() {
        return project;
    }

    /**
     * @return a direct reference to the site renderer.
     * @see org.apache.maven.reporting.AbstractMavenReport#getSiteRenderer()
     */
    protected final SiteRenderer getSiteRenderer() {
        return siteRenderer;
    }

    /**
     * @param aLocale
     *            The locale.
     * @return The locale specific report name.
     * @see org.apache.maven.reporting.MavenReport#getName(java.util.Locale)
     */
    public final String getName(final Locale aLocale) {
        return getBundle(aLocale).getString("report.qalab.movers.name");
    }

    /**
     * @param aLocale
     *            The locale.
     * @return The locale specific report description.
     * @see org.apache.maven.reporting.MavenReport#getDescription(java.util.Locale)
     */
    public final String getDescription(final Locale aLocale) {
        return getBundle(aLocale).getString("report.qalab.movers.description");
    }

    /**
     * @return true.
     * @see org.apache.maven.reporting.MavenReport#isExternalReport
     */
    public final boolean isExternalReport() {
        return true;
    }

    /**
     * @param aLocale
     *            The locale.
     * @return the resource bundle for this report.
     */
    private static ResourceBundle getBundle(final Locale aLocale) {
        return ResourceBundle.getBundle("qalab-report", aLocale, MainReport.class.getClassLoader());
    }

    /**
     * Validates the parameters supplied by maven 2.
     * 
     * @throws MavenReportException
     *             if any supplied params are wrong.
     */
    private void validate() throws MavenReportException {
        try {
            Utils.checkFile(qalabMoversOutputFile, "inputMoversFile");
            theXmlStream = new FileInputStream(qalabMoversOutputFile);
        } catch (IOException ioex) {
            throw new MavenReportException(ioex.getMessage(), ioex);
        }

        if (moversStyleSheet == null) {
            try {
                theStyleSheetStream = Utils.extractAsInputStream(moversBundledXsl);
            } catch (IOException ioex) {
                throw new MavenReportException("Could not find the default stylesheet. " + ioex.getMessage(), ioex);
            }
        } else {
            try {
                Utils.checkFile(moversStyleSheet, "moversStyleSheet");
                theStyleSheetStream = new FileInputStream(moversStyleSheet);
            } catch (IOException ioex) {
                throw new MavenReportException(ioex.getMessage(), ioex);
            }
        }
    }
}
/*
 *                   ObjectLab is sponsoring QALab
 * 
 * Based in London, we are world leaders in the design and development 
 * of bespoke applications for the securities financing markets.
 * 
 * <a href="http://www.objectlab.co.uk/open">Click here to learn more about us</a>
 *           ___  _     _           _   _          _
 *          / _ \| |__ (_) ___  ___| |_| |    __ _| |__
 *         | | | | '_ \| |/ _ \/ __| __| |   / _` | '_ \
 *         | |_| | |_) | |  __/ (__| |_| |__| (_| | |_) |
 *          \___/|_.__// |\___|\___|\__|_____\__,_|_.__/
 *                   |__/
 *
 *                     www.ObjectLab.co.uk
 */
