////////////////////////////////////////////////////////////////////////////////
//
//                  ObjectLab is sponsoring QALab
//
// Based in London, we are world leaders in the design and development
// of bespoke applications for the Securities Financing markets.
//
// <a href="http://www.objectlab.co.uk/open">Click here to learn more</a>
//           ___  _     _           _   _          _
//          / _ \| |__ (_) ___  ___| |_| |    __ _| |__
//         | | | | '_ \| |/ _ \/ __| __| |   / _` | '_ \
//         | |_| | |_) | |  __/ (__| |_| |__| (_| | |_) |
//          \___/|_.__// |\___|\___|\__|_____\__,_|_.__/
//                   |__/
//
//                   http://www.ObjectLab.co.uk
// ---------------------------------------------------------------------------
//
//QALab is released under the GNU General Public License.
//
//QALab: Collects QA Statistics from your build over time.
//2005+, ObjectLab Ltd
//
//This library is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public
//License as published by the Free Software Foundation; either
//version 2.1 of the License, or (at your option) any later version.
//
//This library is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//General Public License for more details.
//
//You should have received a copy of the GNU General Public
//License along with this library; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
////////////////////////////////////////////////////////////////////////////////
package net.objectlab.qalab.m2.util;

import java.io.File;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.InputStream;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

/**
 * Some handy utils for the QALab maven 2 plugin.
 * @author <a href="http://www.davesag.com">Dave Sag</a>.
 */
public final class Utils {

    /**
     * private contructor as this is a utils class.
     */
    private Utils() {
        // does nothing.
    }

    /**
     * performs a simple check that the file is real and readable.
     * @param aFile the file to check
     * @param aParamName the name of the input param - used for error reporting.
     * @throws IOException if the file was null or not readable.
     */
    public static void checkFile(final File aFile, final String aParamName)
             throws IOException {
        if (aFile == null) {
            throw new FileNotFoundException(aParamName
                    + " is mandatory");
        }

        if (!aFile.exists()) {
            throw new FileNotFoundException(aFile
                    + " does not exist.");
        }

        if (!aFile.canRead()) {
            throw new IOException("Unable to read from '"
                    + aFile + "' while processing value for param "
                    + aParamName);
        }

    }

    /**
     * extract an input stream from the supplied resource file. The resource is
     * presumed to be somewhere on the classpath for this app.
     * @param aResourcePath the path to the resource we need the
     *        actual system path for. Must not be empty or null.
     * @return an input stream pointing at the named resource.
     * @throws IOException if the resource path was not readable.
     */
    public static InputStream extractAsInputStream(final String aResourcePath)
            throws IOException {

        assert aResourcePath != null : "The supplied path was null";
        assert !"".equals(aResourcePath) : "The supplied path was empty";

        final ClassLoader l = Utils.class.getClassLoader();
        final InputStream res = l.getResourceAsStream(aResourcePath);
        if (res == null) {
            throw new FileNotFoundException(
                    "could not find resource at " + aResourcePath);
        }
        return res;
    }

    /**
     * Generate a yyyy-MM-dd date based on now less the number of hours
     * to offset.
     * @param anOffset the number of hours to subtract from now.
     * @return a yyyy-MM-dd formatted string representing now less the offset.
     */
    public static String formatDateBasedOnOffset(final String anOffset) {
        assert anOffset != null : "offset supplied must not be null";
        final int hours = Integer.parseInt(anOffset);
        assert hours > 0 : "offset supplied must be positive";

        final Calendar c = Calendar.getInstance();
        c.add(Calendar.HOUR, -hours);

        final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd",
                Locale.getDefault());
        return df.format(c.getTime());
    }
}
/*
 *                   ObjectLab is sponsoring QALab
 * 
 * Based in London, we are world leaders in the design and development 
 * of bespoke applications for the securities financing markets.
 * 
 * <a href="http://www.objectlab.co.uk/open">Click here to learn more about us</a>
 *           ___  _     _           _   _          _
 *          / _ \| |__ (_) ___  ___| |_| |    __ _| |__
 *         | | | | '_ \| |/ _ \/ __| __| |   / _` | '_ \
 *         | |_| | |_) | |  __/ (__| |_| |__| (_| | |_) |
 *          \___/|_.__// |\___|\___|\__|_____\__,_|_.__/
 *                   |__/
 *
 *                     www.ObjectLab.co.uk
 */
