/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.autowire.AutoWire;
import net.officefloor.autowire.AutoWireObject;
import net.officefloor.autowire.AutoWireOfficeFloor;
import net.officefloor.autowire.AutoWireSection;
import net.officefloor.compile.OfficeFloorCompiler;
import net.officefloor.frame.impl.spi.team.ProcessContextTeamSource;
import net.officefloor.frame.spi.source.ResourceSource;
import net.officefloor.plugin.servlet.OfficeFloorServlet;
import net.officefloor.plugin.servlet.ServletContainerResourceSectionSource;
import net.officefloor.plugin.servlet.ServletDependencyManagedObjectSource;
import net.officefloor.plugin.servlet.bridge.ServletBridgeManagedObjectSource;
import net.officefloor.plugin.servlet.bridge.spi.ServletServiceBridger;
import net.officefloor.plugin.servlet.socket.server.http.source.ServletServerHttpConnectionManagedObjectSource;
import net.officefloor.plugin.servlet.web.http.application.ServletHttpApplicationStateManagedObjectSource;
import net.officefloor.plugin.servlet.web.http.application.ServletHttpRequestStateManagedObjectSource;
import net.officefloor.plugin.servlet.web.http.session.ServletHttpSessionManagedObjectSource;
import net.officefloor.plugin.socket.server.http.ServerHttpConnection;
import net.officefloor.plugin.web.http.application.HttpApplicationState;
import net.officefloor.plugin.web.http.application.HttpRequestState;
import net.officefloor.plugin.web.http.application.WebApplicationAutoWireOfficeFloorSource;
import net.officefloor.plugin.web.http.application.WebAutoWireApplication;
import net.officefloor.plugin.web.http.session.HttpSession;

public class ServletWebAutoWireApplication<S extends OfficeFloorServlet>
extends WebApplicationAutoWireOfficeFloorSource
implements WebAutoWireApplication {
    private static Map<Integer, ServletWebAutoWireApplication<?>> registeredApplications = new HashMap();
    private static int nextApplicationIndex = 1;
    private static final String INIT_PROPERTY_APPLICATION_INDEX = "officefloorservlet.application.index";
    private ServletServiceBridger<S> bridger;
    private final List<ServletResourceLink> servletResourceLinks = new LinkedList<ServletResourceLink>();
    private final List<ServletResourceEscalation> servletResourceEscalations = new LinkedList<ServletResourceEscalation>();
    private AutoWireOfficeFloor officeFloor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Map<Integer, ServletWebAutoWireApplication<?>> map = registeredApplications;
        synchronized (map) {
            registeredApplications.clear();
            nextApplicationIndex = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void configure(OfficeFloorServlet servletInitiateInstance, final ServletContext servletContext) {
        int applicationIndex;
        Class<?>[] dependencyTypes;
        String servletName = servletInitiateInstance.getServletName();
        Class<?> servletClass = ((Object)((Object)servletInitiateInstance)).getClass();
        if (servletContext.getServletRegistration(servletName) != null) {
            servletContext.log("Not registering " + OfficeFloorServlet.class.getSimpleName() + " " + servletName + " (" + servletClass.getName() + ") as " + Servlet.class.getSimpleName() + " already registered under name");
            return;
        }
        ServletWebAutoWireApplication source = new ServletWebAutoWireApplication();
        source.bridger = ServletBridgeManagedObjectSource.createServletServiceBridger(servletClass, source, "HANDLE_HTTP_SECTION", "HANDLE_HTTP_INPUT");
        OfficeFloorCompiler compiler = source.getOfficeFloorCompiler();
        compiler.addResources(new ResourceSource(){

            public InputStream sourceResource(String location) {
                location = location.startsWith("/") ? location : "/" + location;
                InputStream resource = servletContext.getResourceAsStream(location);
                return resource;
            }
        });
        source.addManagedObject(ServletServerHttpConnectionManagedObjectSource.class.getName(), null, new AutoWire[]{new AutoWire(ServerHttpConnection.class)});
        source.addManagedObject(ServletHttpSessionManagedObjectSource.class.getName(), null, new AutoWire[]{new AutoWire(HttpSession.class)});
        source.addManagedObject(ServletHttpApplicationStateManagedObjectSource.class.getName(), null, new AutoWire[]{new AutoWire(HttpApplicationState.class)});
        source.addManagedObject(ServletHttpRequestStateManagedObjectSource.class.getName(), null, new AutoWire[]{new AutoWire(HttpRequestState.class)});
        for (Class<?> clazz : dependencyTypes = source.bridger.getObjectTypes()) {
            AutoWireObject dependency = source.addManagedObject(ServletDependencyManagedObjectSource.class.getName(), null, new AutoWire[]{new AutoWire(clazz)});
            dependency.addProperty("type.name", clazz.getName());
        }
        if (dependencyTypes.length > 0) {
            AutoWire[] autoWiring = new AutoWire[dependencyTypes.length];
            for (int i = 0; i < autoWiring.length; ++i) {
                autoWiring[i] = new AutoWire(dependencyTypes[i]);
            }
            source.assignTeam(ProcessContextTeamSource.class.getName(), autoWiring);
        }
        String contextPath = servletContext.getContextPath();
        compiler.addProperty("http.context.path", contextPath);
        try {
            boolean isConfigure = servletInitiateInstance.configure(source, servletContext);
            if (!isConfigure) {
                return;
            }
        }
        catch (Exception ex) {
            servletContext.log("Failed to configure " + servletClass.getName() + ". It will not be available.", (Throwable)ex);
            return;
        }
        AutoWireSection servletContainerResource = source.addSection("SERVLET_CONTAINER_RESOURCE", ServletContainerResourceSectionSource.class.getName(), "NOT_HANDLED");
        source.chainServicer(servletContainerResource, "NOT_HANDLED", null);
        for (ServletResourceLink servletResourceLink : source.servletResourceLinks) {
            servletContainerResource.addProperty(servletResourceLink.requestDispatcherPath, servletResourceLink.requestDispatcherPath);
            source.link(servletResourceLink.section, servletResourceLink.outputName, servletContainerResource, servletResourceLink.requestDispatcherPath);
        }
        for (ServletResourceEscalation servletResourceEscalation : source.servletResourceEscalations) {
            servletContainerResource.addProperty(servletResourceEscalation.requestDispatcherPath, servletResourceEscalation.requestDispatcherPath);
            source.linkEscalation(servletResourceEscalation.escalationType, servletContainerResource, servletResourceEscalation.requestDispatcherPath);
        }
        Map<Integer, ServletWebAutoWireApplication<?>> map = registeredApplications;
        synchronized (map) {
            applicationIndex = nextApplicationIndex++;
            registeredApplications.put(applicationIndex, source);
        }
        String[] stringArray = source.getURIs();
        String[] mappedUris = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            String uri = stringArray[i];
            mappedUris[i] = uri = uri.startsWith("/") ? uri : "/" + uri;
            if (contextPath == null || "/".equals(contextPath)) continue;
            uri = contextPath + uri;
        }
        mappedUris[mappedUris.length - 1] = "*.task";
        ServletRegistration.Dynamic dynamic = servletContext.addServlet(servletName, servletClass);
        dynamic.setInitParameter(INIT_PROPERTY_APPLICATION_INDEX, String.valueOf(applicationIndex));
        dynamic.addMapping(mappedUris);
        dynamic.setLoadOnStartup(1);
        FilterRegistration.Dynamic filter = servletContext.addFilter(servletName, servletClass);
        filter.setInitParameter(INIT_PROPERTY_APPLICATION_INDEX, String.valueOf(applicationIndex));
        filter.addMappingForUrlPatterns(null, false, mappedUris);
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(servletName + " Servlet/Filter (" + servletClass.getName() + ") loaded to service ");
        boolean isFirst = true;
        for (String mappedUri : mappedUris) {
            if (!isFirst) {
                logMessage.append(", ");
            }
            isFirst = false;
            logMessage.append(mappedUri);
        }
        servletContext.log(logMessage.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized <I extends OfficeFloorServlet> ServletWebAutoWireApplication<I> initiate(I servletInstance) throws ServletException {
        ServletWebAutoWireApplication<?> application;
        String applicationIndex = servletInstance.getInitParameter(INIT_PROPERTY_APPLICATION_INDEX);
        if (applicationIndex == null) {
            throw new ServletException(((Object)servletInstance).getClass().getName() + " is not configured correctly as it has no corresponding " + ServletWebAutoWireApplication.class.getSimpleName());
        }
        Map<Integer, ServletWebAutoWireApplication<?>> map = registeredApplications;
        synchronized (map) {
            application = registeredApplications.get(Integer.valueOf(applicationIndex));
        }
        if (application == null) {
            throw new ServletException(((Object)servletInstance).getClass().getName() + " is not configured correctly as it has no corresponding " + ServletWebAutoWireApplication.class.getSimpleName());
        }
        if (application.officeFloor == null) {
            try {
                application.officeFloor = application.openOfficeFloor();
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        return application;
    }

    public boolean service(S servletInstance, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.bridger.service(servletInstance, request, response, request.getServletContext());
        boolean isHandled = ServletContainerResourceSectionSource.completeServletService(request, response);
        return isHandled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Class<ServletWebAutoWireApplication> clazz = ServletWebAutoWireApplication.class;
        synchronized (ServletWebAutoWireApplication.class) {
            if (this.officeFloor != null) {
                this.officeFloor.closeOfficeFloor();
                this.officeFloor = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ServletWebAutoWireApplication() {
    }

    public void linkToResource(AutoWireSection section, String outputName, String requestDispatcherPath) {
        this.servletResourceLinks.add(new ServletResourceLink(section, outputName, requestDispatcherPath));
    }

    public void linkEscalation(Class<? extends Throwable> escalation, String resourcePath) {
        this.servletResourceEscalations.add(new ServletResourceEscalation(escalation, resourcePath));
    }

    private static class ServletResourceEscalation {
        public final Class<? extends Throwable> escalationType;
        public final String requestDispatcherPath;

        public ServletResourceEscalation(Class<? extends Throwable> escalationType, String requestDispatcherPath) {
            this.escalationType = escalationType;
            this.requestDispatcherPath = requestDispatcherPath;
        }
    }

    private static class ServletResourceLink {
        public final AutoWireSection section;
        public final String outputName;
        public final String requestDispatcherPath;

        public ServletResourceLink(AutoWireSection section, String outputName, String requestDispatcherPath) {
            this.section = section;
            this.outputName = outputName;
            this.requestDispatcherPath = requestDispatcherPath;
        }
    }
}

