/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.context;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.frame.api.manage.Office;
import net.officefloor.frame.api.manage.TaskManager;
import net.officefloor.frame.api.manage.WorkManager;
import net.officefloor.plugin.servlet.container.HttpServletServicer;
import net.officefloor.plugin.servlet.container.IteratorEnumeration;
import net.officefloor.plugin.servlet.container.ServletRequestForwarder;
import net.officefloor.plugin.servlet.context.MappedHttpServletRequest;
import net.officefloor.plugin.servlet.context.OfficeServletContext;
import net.officefloor.plugin.servlet.context.ServletTaskReference;
import net.officefloor.plugin.servlet.filter.FilterChainFactory;
import net.officefloor.plugin.servlet.filter.FilterChainFactoryImpl;
import net.officefloor.plugin.servlet.filter.FilterServicer;
import net.officefloor.plugin.servlet.filter.configuration.FilterServicersFactory;
import net.officefloor.plugin.servlet.host.ServletServer;
import net.officefloor.plugin.servlet.mapping.ServicerMapper;
import net.officefloor.plugin.servlet.mapping.ServicerMapperImpl;
import net.officefloor.plugin.servlet.mapping.ServicerMapping;

public class OfficeServletContextImpl
implements OfficeServletContext {
    private final String servletContextName;
    private final Map<String, String> initParameters;
    private final FilterServicer[] filterServicers;
    private final Map<String, String> fileExtensionToMimeType;
    private final Map<Office, OfficeContext> contexts = new HashMap<Office, OfficeContext>();
    private final Map<Office, FilterChainFactory> filterChainFactories = new HashMap<Office, FilterChainFactory>();
    private volatile ServletServer servletServer;

    public OfficeServletContextImpl(String servletContextName, Map<String, String> initParameters, Map<String, String> fileExtensionToMimeType, Properties filterConfiguration, ClassLoader classLoader) throws ServletException {
        this.servletContextName = servletContextName;
        this.initParameters = initParameters;
        this.fileExtensionToMimeType = fileExtensionToMimeType;
        this.filterServicers = new FilterServicersFactory().createFilterServices(filterConfiguration, classLoader, this);
    }

    public void init(ServletServer servletServer) {
        if (this.servletServer == null) {
            this.servletServer = servletServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeContext getOfficeContext(Office office) {
        Map<Office, OfficeContext> map = this.contexts;
        synchronized (map) {
            OfficeContext context = this.contexts.get(office);
            if (context == null) {
                LinkedList<OfficeServicer> servicers = new LinkedList<OfficeServicer>();
                try {
                    for (String workName : office.getWorkNames()) {
                        WorkManager work = office.getWorkManager(workName);
                        for (String taskName : work.getTaskNames()) {
                            TaskManager task = work.getTaskManager(taskName);
                            Object differentiator = task.getDifferentiator();
                            if (!(differentiator instanceof HttpServletServicer)) continue;
                            HttpServletServicer httpServlet = (HttpServletServicer)differentiator;
                            OfficeServicer servicer = new OfficeServicer(workName, taskName, httpServlet);
                            servicers.add(servicer);
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                context = new OfficeContext(servicers.toArray(new HttpServletServicer[0]));
                this.contexts.put(office, context);
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterChainFactory getFilterChainFactory(Office office) throws ServletException {
        Map<Office, FilterChainFactory> map = this.filterChainFactories;
        synchronized (map) {
            FilterChainFactory factory = this.filterChainFactories.get(office);
            if (factory == null) {
                factory = new FilterChainFactoryImpl(office, this.filterServicers);
                this.filterChainFactories.put(office, factory);
            }
            return factory;
        }
    }

    @Override
    public ServletTaskReference mapPath(Office office, String path) {
        OfficeContext context = this.getOfficeContext(office);
        ServicerMapping mapping = context.mapper.mapPath(path);
        if (mapping == null) {
            return null;
        }
        OfficeServicer officeServicer = (OfficeServicer)mapping.getServicer();
        return officeServicer;
    }

    @Override
    public String getContextPath(Office office) {
        return this.servletServer.getContextPath();
    }

    @Override
    public ServletContext getContext(Office office, String uripath) {
        return null;
    }

    @Override
    public String getMimeType(Office office, String file) {
        int extensionIndex = file.lastIndexOf(46);
        if (extensionIndex < 0) {
            return null;
        }
        String fileExtension = file.substring(extensionIndex + 1);
        String mimeType = this.fileExtensionToMimeType.get(fileExtension.toLowerCase());
        return mimeType;
    }

    @Override
    public Set getResourcePaths(Office office, String path) {
        return this.servletServer.getResourceLocator().getResourceChildren(path);
    }

    @Override
    public URL getResource(Office office, String path) throws MalformedURLException {
        return this.servletServer.getResourceLocator().getResource(path);
    }

    @Override
    public InputStream getResourceAsStream(Office office, String path) {
        return this.servletServer.getResourceLocator().getResourceAsStream(path);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(Office office, String path) {
        OfficeContext context = this.getOfficeContext(office);
        ServicerMapping mapping = context.mapper.mapPath(path);
        if (mapping == null) {
            return null;
        }
        OfficeServicer officeServicer = (OfficeServicer)mapping.getServicer();
        return officeServicer.createRequestDispatcher(mapping);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(Office office, String name) {
        OfficeContext context = this.getOfficeContext(office);
        HttpServletServicer servicer = context.mapper.mapName(name);
        if (servicer == null) {
            return null;
        }
        OfficeServicer officeServicer = (OfficeServicer)servicer;
        return officeServicer.createRequestDispatcher(null);
    }

    @Override
    public void log(Office office, String msg) {
        this.servletServer.getLogger().log(msg);
    }

    @Override
    public void log(Office office, String message, Throwable throwable) {
        this.servletServer.getLogger().log(message, throwable);
    }

    @Override
    public String getRealPath(Office office, String path) {
        String serverName = this.servletServer.getServerName();
        int serverPort = this.servletServer.getServerPort();
        String contextPath = this.servletServer.getContextPath();
        String realPath = "http://" + serverName + (serverPort == 80 ? "" : ":" + serverPort) + contextPath;
        realPath = realPath + (path.startsWith("/") ? path : "/" + path);
        return realPath;
    }

    @Override
    public String getServerInfo(Office office) {
        return "OfficeFloor servlet plug-in/1.0";
    }

    @Override
    public String getInitParameter(Office office, String name) {
        return this.initParameters.get(name);
    }

    @Override
    public Enumeration getInitParameterNames(Office office) {
        return new IteratorEnumeration<String>(this.initParameters.keySet().iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(Office office, String name) {
        OfficeContext context;
        OfficeContext officeContext = context = this.getOfficeContext(office);
        synchronized (officeContext) {
            return context.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration getAttributeNames(Office office) {
        OfficeContext context;
        OfficeContext officeContext = context = this.getOfficeContext(office);
        synchronized (officeContext) {
            ArrayList<String> names = new ArrayList<String>(context.attributes.keySet());
            return new IteratorEnumeration(names.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(Office office, String name) {
        OfficeContext context;
        OfficeContext officeContext = context = this.getOfficeContext(office);
        synchronized (officeContext) {
            context.attributes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(Office office, String name, Object object) {
        OfficeContext context;
        OfficeContext officeContext = context = this.getOfficeContext(office);
        synchronized (officeContext) {
            context.attributes.put(name, object);
        }
    }

    @Override
    public String getServletContextName(Office office) {
        return this.servletContextName;
    }

    private class OfficeRequestDispatcher
    implements RequestDispatcher {
        private final String workName;
        private final String taskName;
        private final HttpServletServicer httpServlet;
        private final ServicerMapping mapping;

        public OfficeRequestDispatcher(String workName, String taskName, HttpServletServicer httpServlet, ServicerMapping mapping) {
            this.workName = workName;
            this.taskName = taskName;
            this.httpServlet = httpServlet;
            this.mapping = mapping;
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            ServletRequestForwarder forwarder = null;
            Object object = request.getAttribute("#net.officefloor.servlet.request.forwarder#");
            if (object instanceof ServletRequestForwarder) {
                forwarder = (ServletRequestForwarder)object;
            }
            if (forwarder == null) {
                throw new IllegalStateException(ServletRequestForwarder.class.getSimpleName() + " must be available from the " + ServletRequest.class.getSimpleName());
            }
            forwarder.forward(this.workName, this.taskName, this.mapping);
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            if (this.mapping != null) {
                httpRequest = new MappedHttpServletRequest(this.mapping, httpRequest);
            }
            this.httpServlet.include(OfficeServletContextImpl.this, httpRequest, httpResponse);
        }
    }

    private class OfficeServicer
    implements HttpServletServicer,
    ServletTaskReference {
        private final String workName;
        private final String taskName;
        private final HttpServletServicer httpServlet;

        public OfficeServicer(String workName, String taskName, HttpServletServicer httpServlet) {
            this.workName = workName;
            this.taskName = taskName;
            this.httpServlet = httpServlet;
        }

        public RequestDispatcher createRequestDispatcher(ServicerMapping mapping) {
            return new OfficeRequestDispatcher(this.workName, this.taskName, this.httpServlet, mapping);
        }

        @Override
        public String getServletName() {
            return this.httpServlet.getServletName();
        }

        @Override
        public String[] getServletMappings() {
            return this.httpServlet.getServletMappings();
        }

        @Override
        public void include(OfficeServletContext context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.httpServlet.include(context, request, response);
        }

        @Override
        public String getWorkName() {
            return this.workName;
        }

        @Override
        public String getTaskName() {
            return this.taskName;
        }
    }

    private static class OfficeContext {
        public final Map<String, Object> attributes = new HashMap<String, Object>();
        public final ServicerMapper mapper;

        public OfficeContext(HttpServletServicer[] servletServicers) {
            this.mapper = new ServicerMapperImpl(servletServicers);
        }
    }
}

