/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.context.source;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.spi.managedobject.CoordinatingManagedObject;
import net.officefloor.frame.spi.managedobject.ManagedObject;
import net.officefloor.frame.spi.managedobject.ObjectRegistry;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectSourceContext;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractManagedObjectSource;
import net.officefloor.plugin.servlet.context.OfficeServletContext;
import net.officefloor.plugin.servlet.context.OfficeServletContextImpl;
import net.officefloor.plugin.servlet.host.ServletServer;

public class OfficeServletContextManagedObjectSource
extends AbstractManagedObjectSource<DependencyKeys, None>
implements CoordinatingManagedObject<DependencyKeys> {
    public static final String PROPERTY_SERVLET_CONTEXT_NAME = "servlet.context.name";
    public static final String PROPERTY_PREFIX_INIT_PARAMETER = "init.parameter.";
    public static final String PROPERTY_PREFIX_FILE_EXTENSION_TO_MIME_TYPE = "file.ext.to.mime.type.";
    public static final String PROPERTY_FILTER_INSTANCE_NAME_PREFIX = "filter.instance.name.";
    public static final String PROPERTY_FILTER_INSTANCE_INIT_PREFIX = "filter.instance.init.";
    public static final String PROPERTY_FILTER_MAPPING_INDEX_PREFIX = "filter.mapping.index.";
    public static final String PROPERTY_FILTER_MAPPING_URL_PREFIX = "filter.mapping.url.";
    public static final String PROPERTY_FILTER_MAPPING_SERVLET_PREFIX = "filter.mapping.servlet.";
    public static final String PROPERTY_FILTER_MAPPING_TYPE_PREFIX = "filter.mapping.type.";
    private OfficeServletContextImpl officeServletContext;

    public Map<String, String> loadMappings(String prefix, ManagedObjectSourceContext<None> context, Map<String, String> mappings) {
        Properties properties = context.getProperties();
        for (String name : properties.stringPropertyNames()) {
            if (!name.startsWith(prefix)) continue;
            String key = name.substring(prefix.length());
            mappings.put(key, properties.getProperty(name));
        }
        return mappings;
    }

    protected void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
        context.addProperty(PROPERTY_SERVLET_CONTEXT_NAME, "Servlet Context Name");
    }

    protected void loadMetaData(AbstractAsyncManagedObjectSource.MetaDataContext<DependencyKeys, None> context) throws Exception {
        ManagedObjectSourceContext mosContext = context.getManagedObjectSourceContext();
        String servletContextName = mosContext.getProperty(PROPERTY_SERVLET_CONTEXT_NAME);
        Map<String, String> initParameters = this.loadMappings(PROPERTY_PREFIX_INIT_PARAMETER, (ManagedObjectSourceContext<None>)mosContext, new HashMap<String, String>());
        HashMap<String, String> fileExtensionToMimeType = new HashMap<String, String>();
        fileExtensionToMimeType.put("css", "text/css");
        fileExtensionToMimeType.put("gif", "image/gif");
        fileExtensionToMimeType.put("htm", "text/html");
        fileExtensionToMimeType.put("html", "text/html");
        fileExtensionToMimeType.put("ico", "image/x-icon");
        fileExtensionToMimeType.put("jpeg", "image/jpeg");
        fileExtensionToMimeType.put("jpg", "image/jpeg");
        fileExtensionToMimeType.put("js", "application/x-javascript");
        fileExtensionToMimeType.put("log", "text/plain");
        fileExtensionToMimeType.put("pdf", "application/pdf");
        fileExtensionToMimeType.put("png", "image/png");
        fileExtensionToMimeType.put("txt", "text/plain");
        fileExtensionToMimeType.put("xml", "text/xml");
        this.loadMappings(PROPERTY_PREFIX_FILE_EXTENSION_TO_MIME_TYPE, (ManagedObjectSourceContext<None>)mosContext, fileExtensionToMimeType);
        Properties properties = mosContext.getProperties();
        ClassLoader classLoader = mosContext.getClassLoader();
        this.officeServletContext = new OfficeServletContextImpl(servletContextName, initParameters, fileExtensionToMimeType, properties, classLoader);
        context.setObjectClass(OfficeServletContext.class);
        context.setManagedObjectClass(((Object)((Object)this)).getClass());
        context.addDependency((Enum)DependencyKeys.SERVLET_SERVER, ServletServer.class);
    }

    protected ManagedObject getManagedObject() throws Throwable {
        return this;
    }

    public void loadObjects(ObjectRegistry<DependencyKeys> registry) throws Throwable {
        ServletServer servletServer = (ServletServer)registry.getObject((Enum)DependencyKeys.SERVLET_SERVER);
        this.officeServletContext.init(servletServer);
    }

    public Object getObject() throws Throwable {
        return this.officeServletContext;
    }

    public static enum DependencyKeys {
        SERVLET_SERVER;

    }
}

