/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.filter.configuration;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.officefloor.compile.properties.Property;
import net.officefloor.compile.properties.PropertyList;

public class FilterInstance {
    private String name;
    private String className;
    private final List<InitParam> initParameters = new LinkedList<InitParam>();

    public static FilterInstance[] loadFilterInstances(PropertyList properties) {
        LinkedList<FilterInstance> instances = new LinkedList<FilterInstance>();
        for (String propertyName : properties.getPropertyNames()) {
            if (!propertyName.startsWith("filter.instance.name.")) continue;
            String name = propertyName.substring("filter.instance.name.".length());
            FilterInstance instance = new FilterInstance(name);
            instance.inputProperties(properties);
            instances.add(instance);
        }
        return instances.toArray(new FilterInstance[0]);
    }

    public FilterInstance(String name) {
        this.name = name;
    }

    public FilterInstance(String name, String className, String ... initParameterNameValues) {
        this.name = name;
        this.className = className;
        for (int i = 0; i < initParameterNameValues.length; i += 2) {
            this.initParameters.add(new InitParam(initParameterNameValues[i], initParameterNameValues[i + 1]));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.add(new InitParam(name, value));
    }

    public Map<String, String> getInitParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        for (InitParam initParam : this.initParameters) {
            params.put(initParam.name, initParam.value);
        }
        return params;
    }

    public void outputProperties(PropertyList properties) {
        String propertyName = "filter.instance.name." + this.name;
        properties.addProperty(propertyName).setValue(this.className);
        String initParameterPrefix = "filter.instance.init." + this.name + ".";
        for (InitParam initParam : this.initParameters) {
            properties.addProperty(initParameterPrefix + initParam.name).setValue(initParam.value);
        }
    }

    public void inputProperties(PropertyList properties) {
        String propertyName = "filter.instance.name." + this.name;
        this.className = properties.getPropertyValue(propertyName, null);
        String initParameterPrefix = "filter.instance.init." + this.name + ".";
        for (Property property : properties) {
            String name = property.getName();
            if (!name.startsWith(initParameterPrefix)) continue;
            name = name.substring(initParameterPrefix.length());
            String value = property.getValue();
            this.initParameters.add(new InitParam(name, value));
        }
    }

    private static class InitParam {
        public final String name;
        public final String value;

        public InitParam(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

