/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.mapping;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import net.officefloor.plugin.servlet.container.HttpServletServicer;
import net.officefloor.plugin.servlet.container.IteratorEnumeration;
import net.officefloor.plugin.servlet.mapping.ServicerMapping;

public class ServicerMappingImpl
implements ServicerMapping {
    private final HttpServletServicer servicer;
    private final String servletPath;
    private final String pathInfo;
    private final String queryString;
    private final Map<String, String[]> parameters;

    public ServicerMappingImpl(HttpServletServicer servicer, String servletPath, String pathInfo, String queryString, Map<String, String[]> parameters) {
        this.servicer = servicer;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    @Override
    public HttpServletServicer getServicer() {
        return this.servicer;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values.length > 0 ? values[0] : null;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return new IteratorEnumeration<String>(this.parameters.keySet().iterator());
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }
}

