/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.resource;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.officefloor.plugin.servlet.resource.ResourceLocator;
import net.officefloor.plugin.web.http.resource.classpath.ClassPathHttpResourceNode;
import net.officefloor.plugin.web.http.resource.classpath.ClasspathHttpResourceFactory;

public class ClassPathResourceLocator
implements ResourceLocator {
    private final ClasspathHttpResourceFactory factory;
    private final ClassLoader classLoader;

    public ClassPathResourceLocator(String classPathPrefix, ClassLoader classLoader, String ... defaultDirectoryFileNames) {
        this.factory = ClasspathHttpResourceFactory.getHttpResourceFactory((String)classPathPrefix, (ClassLoader)classLoader, (String[])defaultDirectoryFileNames);
        this.classLoader = classLoader;
    }

    @Override
    public Set<String> getResourceChildren(String resourcePath) {
        ClassPathHttpResourceNode node = this.factory.getNode(resourcePath);
        if (node == null) {
            return Collections.emptySet();
        }
        ClassPathHttpResourceNode[] childNodes = node.getChildren();
        HashSet<String> children = new HashSet<String>(childNodes.length);
        for (ClassPathHttpResourceNode childNode : childNodes) {
            children.add(childNode.getNodePath());
        }
        return children;
    }

    @Override
    public URL getResource(String resourcePath) throws MalformedURLException {
        ClassPathHttpResourceNode node = this.factory.getNode(resourcePath);
        if (node == null) {
            return null;
        }
        return this.classLoader.getResource(node.getClassPath());
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) {
        ClassPathHttpResourceNode node = this.factory.getNode(resourcePath);
        if (node == null) {
            return null;
        }
        return this.classLoader.getResourceAsStream(node.getClassPath());
    }
}

