/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.socket.server.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.officefloor.plugin.socket.server.http.HttpHeader;
import net.officefloor.plugin.socket.server.http.HttpRequest;
import net.officefloor.plugin.socket.server.http.parse.impl.HttpHeaderImpl;
import net.officefloor.plugin.stream.ServerInputStream;
import net.officefloor.plugin.stream.impl.ServerInputStreamImpl;

public class ServletHttpRequest
implements HttpRequest {
    private final HttpServletRequest servletRequest;
    private List<HttpHeader> headers = null;
    private ServerInputStream entity = null;

    public ServletHttpRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public String getMethod() {
        return this.servletRequest.getMethod();
    }

    public String getRequestURI() {
        String requestUri = this.servletRequest.getRequestURI();
        String queryString = this.servletRequest.getQueryString();
        if (queryString == null || queryString.length() == 0) {
            return requestUri;
        }
        return requestUri + "?" + queryString;
    }

    public String getVersion() {
        return this.servletRequest.getProtocol();
    }

    public synchronized List<HttpHeader> getHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<HttpHeader>();
            Enumeration headerNames = this.servletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration values = this.servletRequest.getHeaders(headerName);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    this.headers.add((HttpHeader)new HttpHeaderImpl(headerName, value));
                }
            }
        }
        return this.headers;
    }

    public synchronized ServerInputStream getEntity() throws IOException {
        if (this.entity == null) {
            int contentLength = this.servletRequest.getContentLength();
            byte[] data = new byte[contentLength];
            ServletInputStream inputStream = this.servletRequest.getInputStream();
            int bytesRead = inputStream.read(data);
            if (bytesRead < 0) {
                bytesRead = 0;
            }
            ServerInputStreamImpl requestEntity = new ServerInputStreamImpl((Object)this.servletRequest);
            requestEntity.inputData(data, 0, bytesRead - 1, false);
            this.entity = requestEntity;
        }
        return this.entity;
    }
}

