/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.socket.server.http;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.plugin.servlet.socket.server.http.ServletHttpRequest;
import net.officefloor.plugin.servlet.socket.server.http.ServletHttpResponse;
import net.officefloor.plugin.socket.server.http.HttpRequest;
import net.officefloor.plugin.socket.server.http.HttpResponse;
import net.officefloor.plugin.socket.server.http.ServerHttpConnection;

public class ServletServerHttpConnection
implements ServerHttpConnection {
    private final HttpServletRequest servletRequest;
    private final HttpRequest httpRequest;
    private final HttpResponse httpResponse;

    public ServletServerHttpConnection(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.servletRequest = servletRequest;
        this.httpRequest = new ServletHttpRequest(this.servletRequest);
        this.httpResponse = new ServletHttpResponse(servletResponse);
    }

    public boolean isSecure() {
        return this.servletRequest.isSecure();
    }

    public InetSocketAddress getLocalAddress() {
        InetAddress address;
        String localAddress = this.servletRequest.getLocalAddr();
        try {
            address = InetAddress.getByName(localAddress);
        }
        catch (UnknownHostException ex) {
            address = null;
        }
        int localPort = this.servletRequest.getLocalPort();
        return new InetSocketAddress(address, localPort);
    }

    public InetSocketAddress getRemoteAddress() {
        InetAddress address;
        String remoteAddress = this.servletRequest.getRemoteAddr();
        try {
            address = InetAddress.getByName(remoteAddress);
        }
        catch (UnknownHostException ex) {
            address = null;
        }
        int remotePort = this.servletRequest.getRemotePort();
        return new InetSocketAddress(address, remotePort);
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }
}

