/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.webxml.model;

import java.util.LinkedList;
import java.util.List;
import net.officefloor.model.AbstractModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.Model;
import net.officefloor.model.RemoveConnectionsAction;

public class FilterMappingModel
extends AbstractModel
implements ItemModel<FilterMappingModel> {
    private String filterName;
    private List<String> urlPattern = new LinkedList<String>();
    private List<String> servletName = new LinkedList<String>();
    private List<String> dispatcher = new LinkedList<String>();

    public FilterMappingModel() {
    }

    public FilterMappingModel(String filterName, String[] urlPattern, String[] servletName, String[] dispatcher) {
        this.filterName = filterName;
        if (urlPattern != null) {
            for (String model : urlPattern) {
                this.urlPattern.add(model);
            }
        }
        if (servletName != null) {
            for (String model : servletName) {
                this.servletName.add(model);
            }
        }
        if (dispatcher != null) {
            for (String model : dispatcher) {
                this.dispatcher.add(model);
            }
        }
    }

    public FilterMappingModel(String filterName, String[] urlPattern, String[] servletName, String[] dispatcher, int x, int y) {
        this.filterName = filterName;
        if (urlPattern != null) {
            for (String model : urlPattern) {
                this.urlPattern.add(model);
            }
        }
        if (servletName != null) {
            for (String model : servletName) {
                this.servletName.add(model);
            }
        }
        if (dispatcher != null) {
            for (String model : dispatcher) {
                this.dispatcher.add(model);
            }
        }
        this.setX(x);
        this.setY(y);
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        String oldValue = this.filterName;
        this.filterName = filterName;
        this.changeField(oldValue, this.filterName, FilterMappingEvent.CHANGE_FILTER_NAME);
    }

    public List<String> getUrlPatterns() {
        return this.urlPattern;
    }

    public void addUrlPattern(String urlPattern) {
        this.addItemToList(urlPattern, this.urlPattern, FilterMappingEvent.ADD_URL_PATTERN);
    }

    public void removeUrlPattern(String urlPattern) {
        this.removeItemFromList(urlPattern, this.urlPattern, FilterMappingEvent.REMOVE_URL_PATTERN);
    }

    public List<String> getServletNames() {
        return this.servletName;
    }

    public void addServletName(String servletName) {
        this.addItemToList(servletName, this.servletName, FilterMappingEvent.ADD_SERVLET_NAME);
    }

    public void removeServletName(String servletName) {
        this.removeItemFromList(servletName, this.servletName, FilterMappingEvent.REMOVE_SERVLET_NAME);
    }

    public List<String> getDispatchers() {
        return this.dispatcher;
    }

    public void addDispatcher(String dispatcher) {
        this.addItemToList(dispatcher, this.dispatcher, FilterMappingEvent.ADD_DISPATCHER);
    }

    public void removeDispatcher(String dispatcher) {
        this.removeItemFromList(dispatcher, this.dispatcher, FilterMappingEvent.REMOVE_DISPATCHER);
    }

    public RemoveConnectionsAction<FilterMappingModel> removeConnections() {
        RemoveConnectionsAction _action = new RemoveConnectionsAction((Model)this);
        return _action;
    }

    public static enum FilterMappingEvent {
        CHANGE_FILTER_NAME,
        ADD_URL_PATTERN,
        REMOVE_URL_PATTERN,
        ADD_SERVLET_NAME,
        REMOVE_SERVLET_NAME,
        ADD_DISPATCHER,
        REMOVE_DISPATCHER;

    }
}

