/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.webxml.model;

import java.util.LinkedList;
import java.util.List;
import net.officefloor.model.AbstractModel;
import net.officefloor.model.ItemModel;
import net.officefloor.model.Model;
import net.officefloor.model.RemoveConnectionsAction;

public class ServletMappingModel
extends AbstractModel
implements ItemModel<ServletMappingModel> {
    private String servletName;
    private List<String> urlPattern = new LinkedList<String>();

    public ServletMappingModel() {
    }

    public ServletMappingModel(String servletName, String[] urlPattern) {
        this.servletName = servletName;
        if (urlPattern != null) {
            for (String model : urlPattern) {
                this.urlPattern.add(model);
            }
        }
    }

    public ServletMappingModel(String servletName, String[] urlPattern, int x, int y) {
        this.servletName = servletName;
        if (urlPattern != null) {
            for (String model : urlPattern) {
                this.urlPattern.add(model);
            }
        }
        this.setX(x);
        this.setY(y);
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        String oldValue = this.servletName;
        this.servletName = servletName;
        this.changeField(oldValue, this.servletName, ServletMappingEvent.CHANGE_SERVLET_NAME);
    }

    public List<String> getUrlPatterns() {
        return this.urlPattern;
    }

    public void addUrlPattern(String urlPattern) {
        this.addItemToList(urlPattern, this.urlPattern, ServletMappingEvent.ADD_URL_PATTERN);
    }

    public void removeUrlPattern(String urlPattern) {
        this.removeItemFromList(urlPattern, this.urlPattern, ServletMappingEvent.REMOVE_URL_PATTERN);
    }

    public RemoveConnectionsAction<ServletMappingModel> removeConnections() {
        RemoveConnectionsAction _action = new RemoveConnectionsAction((Model)this);
        return _action;
    }

    public static enum ServletMappingEvent {
        CHANGE_SERVLET_NAME,
        ADD_URL_PATTERN,
        REMOVE_URL_PATTERN;

    }
}

