/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.stream.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.officefloor.plugin.socket.server.impl.ArrayWriteBuffer;
import net.officefloor.plugin.socket.server.impl.BufferWriteBuffer;
import net.officefloor.plugin.socket.server.protocol.WriteBuffer;
import net.officefloor.plugin.socket.server.protocol.WriteBufferEnum;
import net.officefloor.plugin.stream.WriteBufferReceiver;
import net.officefloor.plugin.stream.impl.ServerOutputStreamImpl;

public class ServletServerOutputStream
extends ServerOutputStreamImpl {
    public ServletServerOutputStream(OutputStream outputStream) {
        super((WriteBufferReceiver)new ServletWriteBufferReceiver(outputStream), 1024);
    }

    private static class ServletWriteBufferReceiver
    implements WriteBufferReceiver {
        private final OutputStream outputStream;
        private volatile boolean isClosed = false;

        public ServletWriteBufferReceiver(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public Object getLock() {
            return this.outputStream;
        }

        public WriteBuffer createWriteBuffer(byte[] data, int length) {
            return new ArrayWriteBuffer(data, length);
        }

        public WriteBuffer createWriteBuffer(ByteBuffer buffer) {
            return new BufferWriteBuffer(buffer);
        }

        public void writeData(WriteBuffer[] data) throws IOException {
            block4: for (WriteBuffer buffer : data) {
                WriteBufferEnum type = buffer.getType();
                switch (type) {
                    case BYTE_ARRAY: {
                        this.outputStream.write(buffer.getData(), 0, buffer.length());
                        continue block4;
                    }
                    case BYTE_BUFFER: {
                        ByteBuffer byteBuffer = buffer.getDataBuffer();
                        byte[] writeData = new byte[byteBuffer.remaining()];
                        byteBuffer.get(writeData);
                        this.outputStream.write(writeData);
                        continue block4;
                    }
                    default: {
                        throw new IllegalStateException("Unknown buffer type: " + type);
                    }
                }
            }
        }

        public void close() throws IOException {
            this.isClosed = true;
            this.outputStream.close();
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

