/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.http.conversation.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.officefloor.plugin.socket.server.http.HttpHeader;
import net.officefloor.plugin.socket.server.http.conversation.HttpConversation;
import net.officefloor.plugin.socket.server.http.conversation.HttpManagedObject;
import net.officefloor.plugin.socket.server.http.conversation.impl.HttpManagedObjectImpl;
import net.officefloor.plugin.socket.server.http.conversation.impl.HttpRequestImpl;
import net.officefloor.plugin.socket.server.http.conversation.impl.HttpResponseImpl;
import net.officefloor.plugin.socket.server.http.parse.HttpRequestParseException;
import net.officefloor.plugin.socket.server.protocol.Connection;
import net.officefloor.plugin.stream.ServerInputStream;

public class HttpConversationImpl
implements HttpConversation {
    private final Connection connection;
    private final Queue<HttpManagedObjectImpl> managedObjects = new LinkedList<HttpManagedObjectImpl>();
    private final int sendBufferSize;
    private final Charset defaultCharset;
    private final boolean isSendStackTraceOnFailure;

    public HttpConversationImpl(Connection connection, int sendBufferSize, Charset defaultCharset, boolean isSendStackTraceOnFailure) {
        this.connection = connection;
        this.sendBufferSize = sendBufferSize;
        this.defaultCharset = defaultCharset;
        this.isSendStackTraceOnFailure = isSendStackTraceOnFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueCompleteResponses() throws IOException {
        HttpConversationImpl httpConversationImpl = this;
        synchronized (httpConversationImpl) {
            Iterator iterator = this.managedObjects.iterator();
            while (iterator.hasNext()) {
                HttpManagedObjectImpl managedObject = (HttpManagedObjectImpl)iterator.next();
                if (!managedObject.queueHttpResponseIfComplete()) {
                    return;
                }
                iterator.remove();
            }
        }
    }

    boolean isSendStackTraceOnFailure() {
        return this.isSendStackTraceOnFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpManagedObject addRequest(String method, String requestURI, String httpVersion, List<HttpHeader> headers, ServerInputStream entity) {
        HttpRequestImpl request = new HttpRequestImpl(method, requestURI, httpVersion, headers, entity);
        HttpResponseImpl response = new HttpResponseImpl(this, this.connection, httpVersion, this.sendBufferSize, this.defaultCharset);
        HttpManagedObjectImpl managedObject = new HttpManagedObjectImpl(this.connection, request, response);
        HttpConversationImpl httpConversationImpl = this;
        synchronized (httpConversationImpl) {
            this.managedObjects.add(managedObject);
        }
        return managedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseFailure(HttpRequestParseException failure, boolean isCloseConnection) throws IOException {
        HttpResponseImpl response = new HttpResponseImpl(this, this.connection, "HTTP/1.0", this.sendBufferSize, this.defaultCharset);
        HttpManagedObjectImpl managedObject = new HttpManagedObjectImpl(response);
        HttpConversationImpl httpConversationImpl = this;
        synchronized (httpConversationImpl) {
            this.managedObjects.add(managedObject);
        }
        response.sendFailure(failure);
    }

    @Override
    public void closeConnection() throws IOException {
        this.connection.close();
    }
}

