/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.http.conversation.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.officefloor.frame.api.escalate.EscalationHandler;
import net.officefloor.plugin.socket.server.http.HttpRequest;
import net.officefloor.plugin.socket.server.http.HttpResponse;
import net.officefloor.plugin.socket.server.http.ServerHttpConnection;
import net.officefloor.plugin.socket.server.http.conversation.HttpManagedObject;
import net.officefloor.plugin.socket.server.http.conversation.impl.HttpRequestImpl;
import net.officefloor.plugin.socket.server.http.conversation.impl.HttpResponseImpl;
import net.officefloor.plugin.socket.server.protocol.Connection;

public class HttpManagedObjectImpl
implements HttpManagedObject,
ServerHttpConnection,
EscalationHandler {
    private static final Logger LOGGER = Logger.getLogger(HttpManagedObjectImpl.class.getName());
    private final Connection connection;
    private final HttpRequestImpl request;
    private final HttpResponseImpl response;

    public HttpManagedObjectImpl(Connection connection, HttpRequestImpl request, HttpResponseImpl response) {
        this.connection = connection;
        this.request = request;
        this.response = response;
    }

    public HttpManagedObjectImpl(HttpResponseImpl completedResponse) {
        this.connection = null;
        this.request = null;
        this.response = completedResponse;
    }

    boolean queueHttpResponseIfComplete() throws IOException {
        return this.response.queueHttpResponseIfComplete();
    }

    public Object getObject() throws Exception {
        return this;
    }

    @Override
    public EscalationHandler getEscalationHandler() {
        return this;
    }

    @Override
    public ServerHttpConnection getServerHttpConnection() {
        return this;
    }

    @Override
    public void cleanup() throws IOException {
        this.response.send();
    }

    @Override
    public HttpRequest getHttpRequest() {
        return this.request;
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.response;
    }

    @Override
    public boolean isSecure() {
        return this.connection.isSecure();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public void handleEscalation(Throwable escalation) throws Throwable {
        block4: {
            try {
                this.response.sendFailure(escalation);
            }
            catch (ClosedChannelException ex) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Failed sending escalation over closed connection", ex);
                }
            }
            catch (IOException ex) {
                if (!LOGGER.isLoggable(Level.INFO)) break block4;
                LOGGER.log(Level.INFO, "Unable to send HTTP failure message", ex);
            }
        }
    }
}

