/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.http.conversation.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.officefloor.plugin.socket.server.http.HttpHeader;
import net.officefloor.plugin.socket.server.http.HttpResponse;
import net.officefloor.plugin.socket.server.http.conversation.impl.HttpConversationImpl;
import net.officefloor.plugin.socket.server.http.parse.HttpRequestParseException;
import net.officefloor.plugin.socket.server.http.parse.impl.HttpHeaderImpl;
import net.officefloor.plugin.socket.server.http.parse.impl.HttpRequestParserImpl;
import net.officefloor.plugin.socket.server.http.protocol.HttpStatus;
import net.officefloor.plugin.socket.server.protocol.Connection;
import net.officefloor.plugin.socket.server.protocol.WriteBuffer;
import net.officefloor.plugin.socket.server.protocol.WriteBufferEnum;
import net.officefloor.plugin.stream.ServerOutputStream;
import net.officefloor.plugin.stream.ServerWriter;
import net.officefloor.plugin.stream.WriteBufferReceiver;
import net.officefloor.plugin.stream.impl.ServerOutputStreamImpl;

public class HttpResponseImpl
implements HttpResponse {
    private static final String EOL = "\r\n";
    private static final String HEADER_NAME_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_NAME_CONTENT_LENGTH = "Content-Length";
    private final HttpConversationImpl conversation;
    private final Connection connection;
    private final int sendBufferSize;
    private final HttpResponseWriteBufferReceiver receiver = new HttpResponseWriteBufferReceiver();
    private String version;
    private int status;
    private String statusMessage;
    private final List<HttpHeader> headers = new LinkedList<HttpHeader>();
    private final ServerOutputStreamImpl entity;
    private boolean isOutputStream = false;
    private String contentType = null;
    private Charset charset;
    private String charsetName;
    private ServerWriter entityWriter = null;
    private boolean isClosed = false;

    public HttpResponseImpl(HttpConversationImpl conversation, Connection connection, String httpVersion, int sendBufferSize, Charset defaultCharset) {
        this.conversation = conversation;
        this.connection = connection;
        this.sendBufferSize = sendBufferSize;
        this.charset = defaultCharset;
        this.charsetName = this.charset.name();
        this.version = httpVersion;
        this.status = 200;
        this.statusMessage = HttpStatus.getStatusMessage(this.status);
        this.entity = new ServerOutputStreamImpl(this.receiver, this.sendBufferSize);
    }

    boolean queueHttpResponseIfComplete() throws IOException {
        return this.receiver.queueHttpResponseIfComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendFailure(Throwable failure) throws IOException {
        Object object = this.connection.getLock();
        synchronized (object) {
            this.resetUnsafe();
            if (failure instanceof HttpRequestParseException) {
                HttpRequestParseException parseFailure = (HttpRequestParseException)failure;
                this.setStatus(parseFailure.getHttpStatus());
            } else {
                this.setStatus(500);
            }
            ServerWriter writer = this.getEntityWriter();
            String failMessage = failure.getClass().getSimpleName() + ": " + failure.getMessage();
            writer.write(failMessage);
            if (this.conversation.isSendStackTraceOnFailure()) {
                writer.write("\n\n");
                PrintWriter stackTraceWriter = new PrintWriter(writer);
                failure.printStackTrace(stackTraceWriter);
                stackTraceWriter.flush();
            }
            this.send();
            this.connection.close();
        }
    }

    private void writeHeader(long contentLength) throws IOException {
        ServerOutputStreamImpl header = new ServerOutputStreamImpl(this.receiver, this.sendBufferSize);
        if (this.contentType != null) {
            this.addHeader(HEADER_NAME_CONTENT_TYPE, this.contentType + (this.charsetName == null ? "" : "; charset=" + this.charsetName));
        }
        this.headers.add(new HttpHeaderImpl(HEADER_NAME_CONTENT_LENGTH, String.valueOf(contentLength)));
        if (contentLength == 0L && this.status == 200) {
            this.setStatus(204);
        }
        HttpResponseImpl.writeUsAscii(this.version + " " + String.valueOf(this.status) + " " + this.statusMessage + EOL, header);
        for (HttpHeader httpHeader : this.headers) {
            String name = httpHeader.getName();
            String value = httpHeader.getValue();
            HttpResponseImpl.writeUsAscii(name + ": " + (value == null ? "" : value) + EOL, header);
        }
        HttpResponseImpl.writeUsAscii(EOL, header);
        ((ServerOutputStream)header).flush();
    }

    private static void writeUsAscii(String value, ServerOutputStream outputStream) throws IOException {
        outputStream.write(value.getBytes(HttpRequestParserImpl.US_ASCII));
    }

    private void resetUnsafe() throws IOException {
        this.headers.clear();
        this.entity.clear();
        this.receiver.entityBuffers.clear();
        this.isOutputStream = false;
        this.entityWriter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVersion(String version) {
        Object object = this.connection.getLock();
        synchronized (object) {
            this.version = version;
        }
    }

    @Override
    public void setStatus(int status) {
        String message = HttpStatus.getStatusMessage(status);
        this.setStatus(status, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(int status, String statusMessage) {
        Object object = this.connection.getLock();
        synchronized (object) {
            this.status = status;
            this.statusMessage = statusMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.connection.getLock();
        synchronized (object) {
            this.resetUnsafe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpHeader addHeader(String name, String value) {
        HttpHeaderImpl header = new HttpHeaderImpl(name, value);
        if (HEADER_NAME_CONTENT_LENGTH.equalsIgnoreCase(name)) {
            return header;
        }
        Object object = this.connection.getLock();
        synchronized (object) {
            this.headers.add(header);
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpHeader getHeader(String name) {
        Object object = this.connection.getLock();
        synchronized (object) {
            for (HttpHeader header : this.headers) {
                if (!name.equalsIgnoreCase(header.getName())) continue;
                return header;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpHeader[] getHeaders() {
        Object object = this.connection.getLock();
        synchronized (object) {
            HttpHeader[] headers;
            Object object2 = this.connection.getLock();
            synchronized (object2) {
                headers = this.headers.toArray(new HttpHeader[0]);
            }
            return headers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHeader(HttpHeader header) {
        Object object = this.connection.getLock();
        synchronized (object) {
            this.headers.remove(header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHeaders(String name) {
        Object object = this.connection.getLock();
        synchronized (object) {
            Iterator<HttpHeader> iterator = this.headers.iterator();
            while (iterator.hasNext()) {
                HttpHeader header = iterator.next();
                if (!name.equalsIgnoreCase(header.getName())) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerOutputStream getEntity() throws IOException {
        Object object = this.receiver.getLock();
        synchronized (object) {
            if (this.entityWriter != null) {
                throw new IOException("getEntityWriter() has already been invoked");
            }
            this.isOutputStream = true;
            return this.entity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContentType(String contentType) {
        Object object = this.receiver.getLock();
        synchronized (object) {
            this.contentType = contentType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContentCharset(Charset charset, String charsetName) throws IOException {
        Object object = this.receiver.getLock();
        synchronized (object) {
            if (this.entityWriter != null) {
                throw new IOException("getEntityWriter() has already been invoked");
            }
            this.charset = charset;
            this.charsetName = charsetName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerWriter getEntityWriter() throws IOException {
        Object object = this.receiver.getLock();
        synchronized (object) {
            if (this.isOutputStream) {
                throw new IOException("getEntity() has already been invoked");
            }
            if (this.contentType == null) {
                this.contentType = "text/html";
            }
            this.entityWriter = new ServerWriter(this.entity, this.charset, this.receiver.getLock());
            return this.entityWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send() throws IOException {
        Object object = this.receiver.getLock();
        synchronized (object) {
            if (this.entityWriter != null) {
                this.entityWriter.close();
            } else {
                this.entity.close();
            }
        }
    }

    private class HttpResponseWriteBufferReceiver
    implements WriteBufferReceiver {
        private WriteBuffer[] headerBuffers = null;
        private boolean isWritingHeader = false;
        private final List<WriteBuffer> entityBuffers = new LinkedList<WriteBuffer>();

        private HttpResponseWriteBufferReceiver() {
        }

        public boolean queueHttpResponseIfComplete() throws IOException {
            if (!this.isClosed()) {
                return false;
            }
            WriteBuffer[] responseData = new WriteBuffer[this.headerBuffers.length + this.entityBuffers.size()];
            int index = 0;
            for (WriteBuffer buffer : this.headerBuffers) {
                responseData[index++] = buffer;
            }
            for (WriteBuffer buffer : this.entityBuffers) {
                responseData[index++] = buffer;
            }
            HttpResponseImpl.this.connection.writeData(responseData);
            return true;
        }

        @Override
        public Object getLock() {
            return HttpResponseImpl.this.connection.getLock();
        }

        @Override
        public WriteBuffer createWriteBuffer(byte[] data, int length) {
            return HttpResponseImpl.this.connection.createWriteBuffer(data, length);
        }

        @Override
        public WriteBuffer createWriteBuffer(ByteBuffer buffer) {
            return HttpResponseImpl.this.connection.createWriteBuffer(buffer);
        }

        @Override
        public void writeData(WriteBuffer[] data) {
            if (this.isWritingHeader) {
                this.headerBuffers = data;
            } else {
                for (WriteBuffer buffer : data) {
                    this.entityBuffers.add(buffer);
                }
            }
        }

        @Override
        public void close() throws IOException {
            long contentLength = 0L;
            block4: for (WriteBuffer buffer : this.entityBuffers) {
                WriteBufferEnum type = buffer.getType();
                switch (type) {
                    case BYTE_ARRAY: {
                        contentLength += (long)buffer.length();
                        continue block4;
                    }
                    case BYTE_BUFFER: {
                        contentLength += (long)buffer.getDataBuffer().remaining();
                        continue block4;
                    }
                }
                throw new IllegalStateException("Unknown " + WriteBuffer.class.getSimpleName() + " type: " + (Object)((Object)type));
            }
            this.isWritingHeader = true;
            HttpResponseImpl.this.writeHeader(contentLength);
            HttpResponseImpl.this.isClosed = true;
            HttpResponseImpl.this.conversation.queueCompleteResponses();
        }

        @Override
        public boolean isClosed() {
            return HttpResponseImpl.this.isClosed;
        }
    }
}

