/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.http.parse;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.easymock.ArgumentsMatcher;

public class UsAsciiUtil {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final byte CR = UsAsciiUtil.convertToUsAscii('\r');
    private static final byte LF = UsAsciiUtil.convertToUsAscii('\n');

    public static void assertEquals(String message, String expected, byte[] actual) {
        TestCase.assertEquals((String)message, (String)expected, (String)UsAsciiUtil.convertToString(actual));
    }

    public static void assertEquals(String expected, byte[] actual) {
        TestCase.assertEquals((String)expected, (String)UsAsciiUtil.convertToString(actual));
    }

    public static byte[] convertToUsAscii(String text) {
        return text.getBytes(US_ASCII);
    }

    public static byte[] convertToHttp(String text) {
        return UsAsciiUtil.convertToHttp(UsAsciiUtil.convertToUsAscii(text));
    }

    public static byte[] convertToHttp(byte[] ascii) {
        ArrayList<Byte> bytes = new ArrayList<Byte>(ascii.length + 10);
        boolean isLastCr = false;
        for (byte character : ascii) {
            if (character == LF && !isLastCr) {
                bytes.add(new Byte(CR));
            }
            bytes.add(character);
            isLastCr = false;
            if (character != CR) continue;
            isLastCr = true;
        }
        byte[] buffer = new byte[bytes.size()];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (Byte)bytes.get(i);
        }
        return buffer;
    }

    public static String convertToString(byte[] ascii) {
        return new String(ascii, US_ASCII);
    }

    public static char convertToChar(byte asciiChar) {
        return UsAsciiUtil.convertToString(new byte[]{asciiChar}).charAt(0);
    }

    public static byte convertToUsAscii(char character) {
        return UsAsciiUtil.convertToUsAscii(String.valueOf(character))[0];
    }

    public static ArgumentsMatcher createUsAsciiMatcher() {
        return new UsAsciiArgumentsMatcher();
    }

    private UsAsciiUtil() {
    }

    private static class UsAsciiArgumentsMatcher
    implements ArgumentsMatcher {
        private UsAsciiArgumentsMatcher() {
        }

        public boolean matches(Object[] expected, Object[] actual) {
            String expectedContent = UsAsciiUtil.convertToString(this.getAsciiContent(expected[0]));
            byte[] actualData = this.getAsciiContent(actual[0]);
            if (actual.length == 3) {
                int offset = (Integer)actual[1];
                int length = (Integer)actual[2];
                byte[] data = new byte[length];
                System.arraycopy(actualData, offset, data, 0, length);
                actualData = data;
            }
            String actualContent = UsAsciiUtil.convertToString(actualData);
            return expectedContent.endsWith(actualContent);
        }

        public String toString(Object[] arguments) {
            return UsAsciiUtil.convertToString(this.getAsciiContent(arguments[0]));
        }

        private byte[] getAsciiContent(Object argument) {
            if (argument == null) {
                return new byte[0];
            }
            if (argument instanceof byte[]) {
                return (byte[])argument;
            }
            if (argument instanceof ByteBuffer) {
                ByteBuffer buffer = (ByteBuffer)argument;
                if (buffer.position() > 0) {
                    buffer = buffer.duplicate();
                    buffer.flip();
                }
                byte[] data = new byte[buffer.limit()];
                buffer.get(data, 0, data.length);
                return data;
            }
            TestCase.fail((String)("Unknown argument type: " + argument.getClass().getName()));
            return null;
        }
    }
}

