/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.http.parse.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.officefloor.plugin.socket.server.http.HttpHeader;
import net.officefloor.plugin.socket.server.http.parse.HttpRequestParseException;
import net.officefloor.plugin.socket.server.http.parse.HttpRequestParser;
import net.officefloor.plugin.socket.server.http.parse.impl.HttpHeaderImpl;
import net.officefloor.plugin.stream.ServerInputStream;
import net.officefloor.plugin.stream.impl.ServerInputStreamImpl;

public class HttpRequestParserImpl
implements HttpRequestParser {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final byte A = HttpRequestParserImpl.UsAscii('A');
    private static final byte F = HttpRequestParserImpl.UsAscii('F');
    private static final byte Z = HttpRequestParserImpl.UsAscii('Z');
    private static final byte a = HttpRequestParserImpl.UsAscii('a');
    private static final byte f = HttpRequestParserImpl.UsAscii('f');
    private static final byte z = HttpRequestParserImpl.UsAscii('z');
    private static final byte _0 = HttpRequestParserImpl.UsAscii('0');
    private static final byte _9 = HttpRequestParserImpl.UsAscii('9');
    private static final byte SP = HttpRequestParserImpl.UsAscii(' ');
    private static final byte HT = HttpRequestParserImpl.UsAscii('\t');
    private static final byte CR = HttpRequestParserImpl.UsAscii('\r');
    private static final byte LF = HttpRequestParserImpl.UsAscii('\n');
    private static final byte COLON = HttpRequestParserImpl.UsAscii(':');
    private static final byte PERCENTAGE = HttpRequestParserImpl.UsAscii('%');
    private static final String HEADER_NAME_CONTENT_LENGTH = "CONTENT-LENGTH";
    private final int maxHeaderCount;
    private final long maxEntityLength;
    private int nextByteToParseIndex;
    private ParseState parseState;
    private long contentLength;
    private final byte[] textBuffer;
    private int nextTextIndex;
    private EscapedCharacterState escapedCharacterState = EscapedCharacterState.NOT_ESCAPED;
    private byte escapedCharacterHighBits;
    private String text_method;
    private String text_path;
    private String text_version;
    private String text_headerName;
    private boolean isMultipleLineHeaderValue;
    private List<HttpHeader> headers;
    private ServerInputStreamImpl entity;

    private static byte UsAscii(char character) {
        return HttpRequestParserImpl.UsAscii(String.valueOf(character))[0];
    }

    private static byte[] UsAscii(String text) {
        return text.getBytes(US_ASCII);
    }

    private static boolean isAlpha(byte character) {
        return character >= A && character <= Z || character >= a && character <= z;
    }

    private static boolean isCtl(byte character) {
        return character <= 31 || character == 127;
    }

    private static boolean isWs(byte character) {
        return character == SP || character == HT;
    }

    private static boolean isText(byte character) {
        return !HttpRequestParserImpl.isCtl(character) || HttpRequestParserImpl.isWs(character);
    }

    private static byte translateEscapedCharacter(byte highBitsCharacter, byte lowBitsCharacter) throws HttpRequestParseException {
        byte highBits = HttpRequestParserImpl.translateEscapedHexCharacterToBits(highBitsCharacter);
        byte lowBits = HttpRequestParserImpl.translateEscapedHexCharacterToBits(lowBitsCharacter);
        byte character = (byte)(highBits << 4 | lowBits);
        return character;
    }

    private static byte translateEscapedHexCharacterToBits(byte character) throws HttpRequestParseException {
        int bits;
        if (character >= _0 && character <= _9) {
            bits = character - _0;
        } else if (character >= A && character <= F) {
            bits = character - A + 10;
        } else if (character >= a && character <= f) {
            bits = character - a + 10;
        } else {
            throw new HttpRequestParseException(400, "Invalid escaped hexidecimal character '" + (char)character + "'");
        }
        return (byte)bits;
    }

    public HttpRequestParserImpl(int maxHeaderCount, int maxTextLength, long maxEntityLength) {
        this.maxHeaderCount = maxHeaderCount;
        this.maxEntityLength = maxEntityLength;
        this.textBuffer = new byte[maxTextLength];
        this.reset();
    }

    private void appendCharacterToText(byte character, int httpErrorStatus, String httpErrorMessage) throws IOException, HttpRequestParseException {
        try {
            this.textBuffer[this.nextTextIndex++] = character;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new HttpRequestParseException(httpErrorStatus, httpErrorMessage);
        }
    }

    private String getTextAsString(boolean isTrim) {
        String text = new String(this.textBuffer, 0, this.nextTextIndex, US_ASCII);
        if (isTrim) {
            text = text.trim();
        }
        this.nextTextIndex = 0;
        return text;
    }

    private void addHttpHeaderAndManageParseState(String name, String value, byte terminatingCharacter) throws HttpRequestParseException {
        if (this.isMultipleLineHeaderValue) {
            if (value.length() == 0) {
                this.processHeader();
                this.parseState = terminatingCharacter == CR ? ParseState.ENTITY_CR : ParseState.ENTITY;
                return;
            }
            int numberOfHeaders = this.headers.size();
            if (numberOfHeaders == 0) {
                throw new HttpRequestParseException(400, "White spacing before first HTTP header");
            }
            HttpHeader header = this.headers.remove(numberOfHeaders - 1);
            name = header.getName();
            value = header.getValue() + " " + value;
        }
        if (name.length() == 0) {
            throw new HttpRequestParseException(400, "Missing header name");
        }
        this.headers.add(new HttpHeaderImpl(name, value));
        this.text_headerName = "";
        this.isMultipleLineHeaderValue = false;
        this.parseState = terminatingCharacter == CR ? ParseState.HEADER_CR : ParseState.HEADER_CR_NAME_SEPARATION;
    }

    private void processHeader() throws HttpRequestParseException {
        String contentLengthValue = null;
        for (HttpHeader header : this.headers) {
            if (!HEADER_NAME_CONTENT_LENGTH.equalsIgnoreCase(header.getName())) continue;
            contentLengthValue = header.getValue();
            break;
        }
        if (contentLengthValue != null) {
            try {
                this.contentLength = Long.parseLong(contentLengthValue);
            }
            catch (NumberFormatException ex) {
                throw new HttpRequestParseException(411, "Content-Length header value must be an integer");
            }
        }
        if (this.contentLength > 0L && this.contentLength > this.maxEntityLength) {
            throw new HttpRequestParseException(413, "Request entity must be less than maximum of " + this.maxEntityLength + " bytes");
        }
        if (("POST".equalsIgnoreCase(this.text_method) || "PUT".equalsIgnoreCase(this.text_method)) && this.contentLength < 0L) {
            throw new HttpRequestParseException(411, "Must provide Content-Length header for " + this.text_method);
        }
    }

    @Override
    public void reset() {
        this.parseState = ParseState.START;
        this.escapedCharacterState = EscapedCharacterState.NOT_ESCAPED;
        this.contentLength = -1L;
        this.nextTextIndex = 0;
        this.text_method = "";
        this.text_path = "";
        this.text_version = "";
        this.text_headerName = "";
        this.isMultipleLineHeaderValue = false;
        this.headers = new ArrayList<HttpHeader>(16);
        this.entity = new ServerInputStreamImpl(new Object());
    }

    @Override
    public int nextByteToParseIndex() {
        return this.nextByteToParseIndex;
    }

    @Override
    public boolean parse(byte[] data, int startIndex) throws IOException, HttpRequestParseException {
        block42: {
            this.nextByteToParseIndex = startIndex;
            if (this.parseState == ParseState.ENTITY) break block42;
            block20: while (this.nextByteToParseIndex < data.length) {
                block43: {
                    byte character = data[this.nextByteToParseIndex];
                    boolean isEscaped = false;
                    switch (this.escapedCharacterState) {
                        case NOT_ESCAPED: {
                            if (character != PERCENTAGE) break;
                            this.escapedCharacterState = EscapedCharacterState.HIGH_BITS;
                            break block43;
                        }
                        case HIGH_BITS: {
                            this.escapedCharacterHighBits = character;
                            this.escapedCharacterState = EscapedCharacterState.LOW_BITS;
                            break block43;
                        }
                        case LOW_BITS: {
                            character = HttpRequestParserImpl.translateEscapedCharacter(this.escapedCharacterHighBits, character);
                            this.escapedCharacterState = EscapedCharacterState.NOT_ESCAPED;
                            isEscaped = true;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown escaped character state: " + (Object)((Object)this.escapedCharacterState));
                        }
                    }
                    switch (this.parseState) {
                        case START: {
                            if (character == CR || character == LF || HttpRequestParserImpl.isWs(character)) break;
                            this.parseState = ParseState.METHOD;
                        }
                        case METHOD: {
                            if (HttpRequestParserImpl.isAlpha(character)) {
                                this.appendCharacterToText(character, 400, "Method too long");
                                break;
                            }
                            if (HttpRequestParserImpl.isWs(character)) {
                                this.text_method = this.getTextAsString(true);
                                this.parseState = ParseState.METHOD_PATH_SEPARATION;
                                break;
                            }
                            throw new HttpRequestParseException(400, "Unexpected character in method '" + character + "'");
                        }
                        case METHOD_PATH_SEPARATION: {
                            if (HttpRequestParserImpl.isWs(character)) break;
                            this.parseState = ParseState.PATH;
                        }
                        case PATH: {
                            if (HttpRequestParserImpl.isWs(character) && !isEscaped) {
                                this.text_path = this.getTextAsString(false);
                                this.parseState = ParseState.PATH_VERSION_SEPARATION;
                                break;
                            }
                            if (!HttpRequestParserImpl.isCtl(character)) {
                                this.appendCharacterToText(character, 414, "Request-URI Too Long");
                                break;
                            }
                            throw new HttpRequestParseException(400, "Unexpected character in path '" + character + "'");
                        }
                        case PATH_VERSION_SEPARATION: {
                            if (HttpRequestParserImpl.isWs(character)) break;
                            this.parseState = ParseState.VERSION;
                        }
                        case VERSION: {
                            if (character == CR || character == LF) {
                                this.text_version = this.getTextAsString(true);
                                this.parseState = character == CR ? ParseState.HEADER_CR : ParseState.HEADER_CR_NAME_SEPARATION;
                                break;
                            }
                            this.appendCharacterToText(character, 400, "Version too long");
                            break;
                        }
                        case HEADER_CR: {
                            if (character == LF) {
                                this.parseState = ParseState.HEADER_CR_NAME_SEPARATION;
                                break;
                            }
                            throw new HttpRequestParseException(400, "Should expect LF after a CR for status line");
                        }
                        case HEADER_CR_NAME_SEPARATION: {
                            if (character == CR) {
                                this.parseState = ParseState.ENTITY_CR;
                                break;
                            }
                            if (character == LF) {
                                this.processHeader();
                                this.parseState = ParseState.ENTITY;
                                break;
                            }
                            if (HttpRequestParserImpl.isWs(character)) {
                                this.isMultipleLineHeaderValue = true;
                                this.parseState = ParseState.HEADER_NAME_VALUE_SEPARATION;
                                break;
                            }
                            if (this.headers.size() >= this.maxHeaderCount) {
                                throw new HttpRequestParseException(400, "Too Many Headers");
                            }
                            this.parseState = ParseState.HEADER_NAME;
                        }
                        case HEADER_NAME: {
                            if (character == COLON && !isEscaped) {
                                this.text_headerName = this.getTextAsString(true);
                                this.parseState = ParseState.HEADER_NAME_VALUE_SEPARATION;
                                break;
                            }
                            if (character == CR || character == LF) {
                                this.text_headerName = this.getTextAsString(true);
                                this.addHttpHeaderAndManageParseState(this.text_headerName, "", character);
                                break;
                            }
                            if (HttpRequestParserImpl.isText(character)) {
                                this.appendCharacterToText(character, 400, "Header name too long");
                                break;
                            }
                            throw new HttpRequestParseException(400, "Unknown header name character '" + character + "'");
                        }
                        case HEADER_NAME_VALUE_SEPARATION: {
                            if (HttpRequestParserImpl.isWs(character)) break;
                            this.parseState = ParseState.HEADER_VALUE;
                        }
                        case HEADER_VALUE: {
                            if (character == CR || character == LF) {
                                String headerValue = this.getTextAsString(true);
                                this.addHttpHeaderAndManageParseState(this.text_headerName, headerValue, character);
                                break;
                            }
                            if (HttpRequestParserImpl.isText(character)) {
                                this.appendCharacterToText(character, 400, "Header value too long");
                                break;
                            }
                            throw new HttpRequestParseException(400, "Unknown header value character '" + character + "'");
                        }
                        case ENTITY_CR: {
                            if (character != LF) {
                                throw new HttpRequestParseException(400, "Should expect LR after a CR after header");
                            }
                            this.processHeader();
                            this.parseState = ParseState.ENTITY;
                            break;
                        }
                        case ENTITY: {
                            break block20;
                        }
                        default: {
                            throw new IllegalStateException("Unknown parse state: " + (Object)((Object)this.parseState));
                        }
                    }
                }
                ++this.nextByteToParseIndex;
            }
        }
        if (this.parseState != ParseState.ENTITY) {
            this.nextByteToParseIndex = -1;
            return false;
        }
        if (this.contentLength > 0L) {
            boolean isFurtherDataRequired;
            int remainingBytes = data.length - this.nextByteToParseIndex;
            long requiredBytes = this.contentLength - (long)this.entity.available();
            boolean bl = isFurtherDataRequired = requiredBytes > (long)remainingBytes;
            if ((long)remainingBytes > requiredBytes) {
                int endIndex = this.nextByteToParseIndex + (int)requiredBytes - 1;
                this.entity.inputData(data, this.nextByteToParseIndex, endIndex, false);
                this.nextByteToParseIndex = endIndex + 1;
            } else {
                this.entity.inputData(data, this.nextByteToParseIndex, data.length - 1, isFurtherDataRequired);
                this.nextByteToParseIndex = -1;
            }
            return !isFurtherDataRequired;
        }
        this.entity.inputData(null, 0, 0, false);
        if (this.nextByteToParseIndex == data.length) {
            this.nextByteToParseIndex = -1;
        }
        return true;
    }

    @Override
    public String getMethod() {
        return this.text_method;
    }

    @Override
    public String getRequestURI() {
        return this.text_path;
    }

    @Override
    public String getHttpVersion() {
        return this.text_version;
    }

    @Override
    public List<HttpHeader> getHeaders() {
        return this.headers;
    }

    @Override
    public ServerInputStream getEntity() {
        return this.entity;
    }

    private static enum EscapedCharacterState {
        NOT_ESCAPED,
        HIGH_BITS,
        LOW_BITS;

    }

    private static enum ParseState {
        START,
        METHOD,
        METHOD_PATH_SEPARATION,
        PATH,
        PATH_VERSION_SEPARATION,
        VERSION,
        HEADER_CR,
        HEADER_CR_NAME_SEPARATION,
        HEADER_NAME,
        HEADER_NAME_VALUE_SEPARATION,
        HEADER_VALUE,
        ENTITY_CR,
        ENTITY;

    }
}

