/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.http.protocol;

import java.nio.charset.Charset;
import net.officefloor.frame.api.build.Indexed;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.spi.managedobject.ManagedObject;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectExecuteContext;
import net.officefloor.frame.spi.managedobject.source.ManagedObjectSourceContext;
import net.officefloor.frame.spi.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.plugin.socket.server.http.ServerHttpConnection;
import net.officefloor.plugin.socket.server.http.conversation.HttpManagedObject;
import net.officefloor.plugin.socket.server.http.conversation.impl.HttpConversationImpl;
import net.officefloor.plugin.socket.server.http.conversation.impl.HttpManagedObjectImpl;
import net.officefloor.plugin.socket.server.http.parse.impl.HttpRequestParserImpl;
import net.officefloor.plugin.socket.server.http.protocol.CleanupTask;
import net.officefloor.plugin.socket.server.http.protocol.HttpConnectionHandler;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocol;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocolContext;
import net.officefloor.plugin.socket.server.protocol.CommunicationProtocolSource;
import net.officefloor.plugin.socket.server.protocol.Connection;

public class HttpCommunicationProtocol
implements CommunicationProtocolSource,
CommunicationProtocol {
    public static final String PROPERTY_IS_SEND_STACK_TRACE_ON_FAILURE = "is.send.stack.trace.on.failure";
    public static final boolean DEFAULT_VALUE_IS_SEND_STACK_TRACE_ON_FAILURE = false;
    private boolean isSendStackTraceOnFailure;
    public static final String PROPERTY_MAXIMUM_HTTP_REQUEST_HEADERS = "max.http.request.headers";
    public static final int DEFAULT_VALUE_MAXIMUM_HTTP_REQUEST_HEADERS = 255;
    private int maximumHttpRequestHeaders;
    public static final String PROPERTY_MAXIMUM_REQUEST_BODY_LENGTH = "max.http.request.body.length";
    public static final long DEFAULT_VALUE_MAXIMUM_REQUEST_BODY_LENGTH = 0x100000L;
    private long maximumRequestBodyLength;
    public static final String PROPERTY_CONNECTION_TIMEOUT = "connection.timeout";
    public static final long DEFAULT_VALUE_CONNECTION_TIMEOUT = 300000L;
    private long connectionTimeout;
    public static final String PROPERTY_MAXIMUM_TEXT_PART_LENGTH = "max.text.part.length";
    public static final int DEFAULT_VALUE_MAXIMUM_TEXT_PART_LENGTH = 255;
    private int maxTextPartLength = 255;
    private int sendBufferSize;
    private Charset defaultCharset;
    private int requestHandlingFlowIndex;
    private ManagedObjectExecuteContext<Indexed> executeContext;

    public void serviceHttpRequest(HttpConnectionHandler handler, HttpManagedObject httpManagedObject) {
        this.executeContext.invokeProcess(this.requestHandlingFlowIndex, (Object)httpManagedObject.getServerHttpConnection(), (ManagedObject)httpManagedObject, 0L, httpManagedObject.getEscalationHandler());
    }

    @Override
    public void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
    }

    @Override
    public CommunicationProtocol createCommunicationProtocol(AbstractAsyncManagedObjectSource.MetaDataContext<None, Indexed> configurationContext, CommunicationProtocolContext protocolContext) throws Exception {
        ManagedObjectSourceContext mosContext = configurationContext.getManagedObjectSourceContext();
        this.isSendStackTraceOnFailure = Boolean.parseBoolean(mosContext.getProperty(PROPERTY_IS_SEND_STACK_TRACE_ON_FAILURE, String.valueOf(false)));
        this.maximumHttpRequestHeaders = Integer.parseInt(mosContext.getProperty(PROPERTY_MAXIMUM_HTTP_REQUEST_HEADERS, String.valueOf(255)));
        this.maximumRequestBodyLength = Long.parseLong(mosContext.getProperty(PROPERTY_MAXIMUM_REQUEST_BODY_LENGTH, String.valueOf(0x100000L)));
        this.connectionTimeout = Long.parseLong(mosContext.getProperty(PROPERTY_CONNECTION_TIMEOUT, String.valueOf(300000L)));
        this.maxTextPartLength = Integer.parseInt(mosContext.getProperty(PROPERTY_MAXIMUM_TEXT_PART_LENGTH, String.valueOf(255)));
        this.sendBufferSize = protocolContext.getSendBufferSize();
        this.defaultCharset = protocolContext.getDefaultCharset();
        configurationContext.setManagedObjectClass(HttpManagedObjectImpl.class);
        configurationContext.setObjectClass(ServerHttpConnection.class);
        this.requestHandlingFlowIndex = configurationContext.addFlow(ServerHttpConnection.class).setLabel("HANDLE_HTTP_REQUEST").getIndex();
        new CleanupTask().registerAsRecycleTask(mosContext, "cleanup");
        return this;
    }

    @Override
    public void setManagedObjectExecuteContext(ManagedObjectExecuteContext<Indexed> executeContext) {
        this.executeContext = executeContext;
    }

    @Override
    public HttpConnectionHandler createConnectionHandler(Connection connection) {
        HttpConversationImpl conversation = new HttpConversationImpl(connection, this.sendBufferSize, this.defaultCharset, this.isSendStackTraceOnFailure);
        HttpRequestParserImpl parser = new HttpRequestParserImpl(this.maximumHttpRequestHeaders, this.maxTextPartLength, this.maximumRequestBodyLength);
        return new HttpConnectionHandler(this, conversation, parser, this.connectionTimeout);
    }
}

