/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.http.protocol;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.officefloor.plugin.socket.server.http.HttpHeader;
import net.officefloor.plugin.socket.server.http.conversation.HttpConversation;
import net.officefloor.plugin.socket.server.http.conversation.HttpManagedObject;
import net.officefloor.plugin.socket.server.http.parse.HttpRequestParseException;
import net.officefloor.plugin.socket.server.http.parse.HttpRequestParser;
import net.officefloor.plugin.socket.server.http.protocol.HttpCommunicationProtocol;
import net.officefloor.plugin.socket.server.protocol.ConnectionHandler;
import net.officefloor.plugin.socket.server.protocol.HeartBeatContext;
import net.officefloor.plugin.socket.server.protocol.ReadContext;
import net.officefloor.plugin.stream.ServerInputStream;

public class HttpConnectionHandler
implements ConnectionHandler {
    private static final Logger LOGGER = Logger.getLogger(HttpConnectionHandler.class.getName());
    private final HttpCommunicationProtocol communicationProtocol;
    private final HttpConversation conversation;
    private final HttpRequestParser parser;
    private final long connectionTimout;
    private long lastInteractionTime = -1L;
    private boolean isParseFailure = false;

    public HttpConnectionHandler(HttpCommunicationProtocol communicationProtocol, HttpConversation conversation, HttpRequestParser parser, long connectionTimeout) {
        this.communicationProtocol = communicationProtocol;
        this.conversation = conversation;
        this.parser = parser;
        this.connectionTimout = connectionTimeout;
    }

    @Override
    public void handleRead(ReadContext context) throws IOException {
        try {
            if (this.isParseFailure) {
                return;
            }
            this.lastInteractionTime = context.getTime();
            byte[] readData = context.getData();
            int startIndex = 0;
            while (startIndex >= 0) {
                if (this.parser.parse(readData, startIndex)) {
                    String method = this.parser.getMethod();
                    String requestURI = this.parser.getRequestURI();
                    String httpVersion = this.parser.getHttpVersion();
                    List<HttpHeader> headers = this.parser.getHeaders();
                    ServerInputStream entity = this.parser.getEntity();
                    this.parser.reset();
                    HttpManagedObject managedObject = this.conversation.addRequest(method, requestURI, httpVersion, headers, entity);
                    this.communicationProtocol.serviceHttpRequest(this, managedObject);
                }
                startIndex = this.parser.nextByteToParseIndex();
            }
        }
        catch (HttpRequestParseException ex) {
            this.isParseFailure = true;
            this.conversation.parseFailure(ex, true);
        }
        catch (IOException ex) {
            this.isParseFailure = true;
            throw ex;
        }
    }

    @Override
    public void handleHeartbeat(HeartBeatContext context) {
        block4: {
            if (this.lastInteractionTime == -1L) {
                this.lastInteractionTime = context.getTime();
                return;
            }
            long currentTime = context.getTime();
            long timeIdle = currentTime - this.lastInteractionTime;
            if (timeIdle >= this.connectionTimout) {
                try {
                    this.conversation.closeConnection();
                }
                catch (IOException ex) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block4;
                    LOGGER.log(Level.FINE, "Failed closing connection on idle", ex);
                }
            }
        }
    }
}

