/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.socket.server.http.protocol;

import java.util.HashMap;
import java.util.Map;

public class HttpStatus {
    public static final int SC_CONTINUE = 100;
    public static final int SC_SWITCHING_PROTOCOLS = 101;
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_RESET_CONTENT = 205;
    public static final int SC_PARTIAL_CONTENT = 206;
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_FOUND = 302;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_USE_PROXY = 305;
    public static final int SC_TEMPORARY_REDIRECT = 307;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_PAYMENT_REQUIRED = 402;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_NOT_ACCEPTABLE = 406;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_REQUEST_TIME_OUT = 408;
    public static final int SC_CONFLICT = 409;
    public static final int SC_GONE = 410;
    public static final int SC_LENGTH_REQUIRED = 411;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int SC_REQUEST_URI_TOO_LARGE = 414;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int SC_EXPECTATION_FAILED = 417;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_GATEWAY_TIME_OUT = 504;
    public static final int SC_HTTP_VERSION_NOT_SUPPORTED = 505;
    private static final Map<Integer, String> statusMessages = new HashMap<Integer, String>();

    public static String getStatusMessage(int statusCode) {
        return statusMessages.get(statusCode);
    }

    private HttpStatus() {
    }

    static {
        statusMessages.put(100, "Continue");
        statusMessages.put(101, "Switching Protocols");
        statusMessages.put(200, "OK");
        statusMessages.put(201, "Created");
        statusMessages.put(202, "Accepted");
        statusMessages.put(203, "Non-Authoritative Information");
        statusMessages.put(204, "No Content");
        statusMessages.put(205, "Reset Content");
        statusMessages.put(206, "Partial Content");
        statusMessages.put(300, "Multiple Choices");
        statusMessages.put(301, "Moved Permanently");
        statusMessages.put(302, "Found");
        statusMessages.put(303, "See Other");
        statusMessages.put(304, "Not Modified");
        statusMessages.put(305, "Use Proxy");
        statusMessages.put(307, "Temporary Redirect");
        statusMessages.put(400, "Bad Request");
        statusMessages.put(401, "Unauthorized");
        statusMessages.put(402, "Payment Required");
        statusMessages.put(403, "Forbidden");
        statusMessages.put(404, "Not Found");
        statusMessages.put(405, "Method Not Allowed");
        statusMessages.put(406, "Not Acceptable");
        statusMessages.put(407, "Proxy Authentication Required");
        statusMessages.put(408, "Request Time-out");
        statusMessages.put(409, "Conflict");
        statusMessages.put(410, "Gone");
        statusMessages.put(411, "Length Required");
        statusMessages.put(412, "Precondition Failed");
        statusMessages.put(413, "Request Entity Too Large");
        statusMessages.put(414, "Request-URI Too Large");
        statusMessages.put(415, "Unsupported Media Type");
        statusMessages.put(416, "Requested range not satisfiable");
        statusMessages.put(417, "Expectation Failed");
        statusMessages.put(500, "Internal Server Error");
        statusMessages.put(501, "Not Implemented");
        statusMessages.put(502, "Bad Gateway");
        statusMessages.put(503, "Service Unavailable");
        statusMessages.put(504, "Gateway Time-out");
        statusMessages.put(505, "HTTP Version not supported");
    }
}

